/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.util.helper;

import com.b100.json.JsonParser;
import com.b100.json.element.JsonArray;
import com.b100.json.element.JsonElement;
import com.b100.json.element.JsonObject;
import com.b100.utils.StringUtils;
import java.io.InputStream;
import net.minecraft.client.render.texturepack.TexturePack;
import net.minecraft.client.render.texturepack.TexturePackException;

public class TexturePackJsonHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonObject readJsonObject(TexturePack texturePack, String path) {
        InputStream stream = null;
        try {
            JsonObject rootObject;
            String string;
            stream = texturePack.getResourceAsStream(path);
            if (stream == null) {
                throw new TexturePackException("File '" + path + "' does not exist!");
            }
            try {
                string = StringUtils.readInputString(stream);
            }
            catch (Exception e) {
                throw new TexturePackException("File '" + path + "' could not be read!", e);
            }
            try {
                rootObject = JsonParser.instance.parseString(string);
            }
            catch (Exception e) {
                throw new TexturePackException("Json Error", e);
            }
            JsonObject jsonObject = rootObject;
            return jsonObject;
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static JsonObject getObject(JsonObject obj, String name) {
        JsonElement element = obj.get(name);
        if (element == null) {
            throw new TexturePackException("Missing \"" + name + "\" object!");
        }
        if (!element.isObject()) {
            throw new TexturePackException("\"" + name + "\" must be an object!");
        }
        return element.getAsObject();
    }

    public static JsonArray getArray(JsonObject obj, String name) {
        JsonElement element = obj.get(name);
        if (element == null) {
            throw new TexturePackException("Missing \"" + name + "\" array!");
        }
        if (!element.isArray()) {
            throw new TexturePackException("\"" + name + "\" must be an array!");
        }
        return element.getAsArray();
    }

    public static String getString(JsonObject obj, String name) {
        JsonElement element = obj.get(name);
        if (element == null) {
            throw new TexturePackException("Missing \"" + name + "\" string!");
        }
        if (!element.isString()) {
            throw new TexturePackException("\"" + name + "\" must be a string!");
        }
        return element.getAsString().value;
    }

    public static int getInteger(JsonObject obj, String name) {
        JsonElement element = obj.get(name);
        if (element == null) {
            throw new TexturePackException("Missing \"" + name + "\" integer!");
        }
        if (!element.isNumber() || !element.getAsNumber().isInteger()) {
            throw new TexturePackException("\"" + name + "\" must be an integer!");
        }
        return element.getAsNumber().getInteger();
    }

    public static boolean getBoolean(JsonObject obj, String name) {
        JsonElement element = obj.get(name);
        if (element == null) {
            throw new TexturePackException("Missing \"" + name + "\" boolean!");
        }
        if (!element.isBoolean()) {
            throw new TexturePackException("\"" + name + "\" must be a boolean!");
        }
        return element.getAsBoolean().value;
    }

    public static int getInteger(JsonArray array, int index) {
        JsonElement element = array.get(index);
        if (!element.isNumber() || !element.getAsNumber().isInteger()) {
            throw new TexturePackException("Index " + index + " must be an integer!");
        }
        return element.getAsNumber().getInteger();
    }

    public static int[] getIntArray(JsonObject obj, String name) {
        JsonArray jsonArray = TexturePackJsonHelper.getArray(obj, name);
        int[] array = new int[jsonArray.length()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = TexturePackJsonHelper.getInteger(jsonArray, i);
        }
        return array;
    }
}

