/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.model;

import net.minecraft.client.GLAllocation;
import net.minecraft.client.render.Polygon;
import net.minecraft.client.render.Vertex;
import net.minecraft.client.render.tessellator.Tessellator;
import org.lwjgl.opengl.GL11;

public class Cube {
    private Vertex[] vertices;
    private Polygon[] polygons;
    private final int textureU;
    private final int textureV;
    private final int texWidth;
    private final int texHeight;
    public float x;
    public float y;
    public float z;
    public float xRot;
    public float yRot;
    public float zRot;
    private boolean compiled = false;
    private int displayList = 0;
    public boolean mirror = false;
    public boolean visible = true;
    public boolean neverRender = false;

    public Cube(int u, int v, int texWidth, int texHeight) {
        this.textureU = u;
        this.textureV = v;
        this.texWidth = texWidth;
        this.texHeight = texHeight;
    }

    public Cube(int u, int v) {
        this(u, v, 64, 32);
    }

    public void addBox(float minX, float minY, float minZ, int sizeX, int sizeY, int sizeZ) {
        this.addBox(minX, minY, minZ, sizeX, sizeY, sizeZ, 0.0f);
    }

    public void addBox(float minX, float minY, float minZ, int sizeX, int sizeY, int sizeZ, float expandAmount) {
        this.addBox(minX, minY, minZ, sizeX, sizeY, sizeZ, expandAmount, false);
    }

    public void addBox(float minX, float minY, float minZ, int sizeX, int sizeY, int sizeZ, float expandAmount, boolean flipBottomUV) {
        this.vertices = new Vertex[8];
        this.polygons = new Polygon[6];
        float maxX = minX + (float)sizeX;
        float maxY = minY + (float)sizeY;
        float maxZ = minZ + (float)sizeZ;
        minX -= expandAmount;
        minY -= expandAmount;
        minZ -= expandAmount;
        maxX += expandAmount;
        maxY += expandAmount;
        maxZ += expandAmount;
        if (this.mirror) {
            float temp = maxX;
            maxX = minX;
            minX = temp;
        }
        Vertex ptvMinXMinYMinZ = new Vertex(minX, minY, minZ, 0.0f, 0.0f);
        Vertex ptvMaxXMinYMinZ = new Vertex(maxX, minY, minZ, 0.0f, 8.0f);
        Vertex ptvMaxXMaxYMinZ = new Vertex(maxX, maxY, minZ, 8.0f, 8.0f);
        Vertex ptvMinXMaxYMinZ = new Vertex(minX, maxY, minZ, 8.0f, 0.0f);
        Vertex ptvMinXMinYMaxZ = new Vertex(minX, minY, maxZ, 0.0f, 0.0f);
        Vertex ptvMaxXMinYMaxZ = new Vertex(maxX, minY, maxZ, 0.0f, 8.0f);
        Vertex ptvMaxXMaxYMaxZ = new Vertex(maxX, maxY, maxZ, 8.0f, 8.0f);
        Vertex ptvMinXMaxYMaxZ = new Vertex(minX, maxY, maxZ, 8.0f, 0.0f);
        this.vertices[0] = ptvMinXMinYMinZ;
        this.vertices[1] = ptvMaxXMinYMinZ;
        this.vertices[2] = ptvMaxXMaxYMinZ;
        this.vertices[3] = ptvMinXMaxYMinZ;
        this.vertices[4] = ptvMinXMinYMaxZ;
        this.vertices[5] = ptvMaxXMinYMaxZ;
        this.vertices[6] = ptvMaxXMaxYMaxZ;
        this.vertices[7] = ptvMinXMaxYMaxZ;
        this.polygons[0] = new Polygon(new Vertex[]{ptvMaxXMinYMaxZ, ptvMaxXMinYMinZ, ptvMaxXMaxYMinZ, ptvMaxXMaxYMaxZ}, this.textureU + sizeZ + sizeX, this.textureV + sizeZ, this.textureU + sizeZ + sizeX + sizeZ, this.textureV + sizeZ + sizeY, this.texWidth, this.texHeight);
        this.polygons[1] = new Polygon(new Vertex[]{ptvMinXMinYMinZ, ptvMinXMinYMaxZ, ptvMinXMaxYMaxZ, ptvMinXMaxYMinZ}, this.textureU, this.textureV + sizeZ, this.textureU + sizeZ, this.textureV + sizeZ + sizeY, this.texWidth, this.texHeight);
        this.polygons[2] = new Polygon(new Vertex[]{ptvMaxXMinYMaxZ, ptvMinXMinYMaxZ, ptvMinXMinYMinZ, ptvMaxXMinYMinZ}, this.textureU + sizeZ, this.textureV, this.textureU + sizeZ + sizeX, this.textureV + sizeZ, this.texWidth, this.texHeight);
        if (flipBottomUV) {
            this.polygons[3] = new Polygon(new Vertex[]{ptvMaxXMaxYMaxZ, ptvMinXMaxYMaxZ, ptvMinXMaxYMinZ, ptvMaxXMaxYMinZ}, this.textureU + sizeZ + sizeX, this.textureV, this.textureU + sizeZ + sizeX + sizeX, this.textureV + sizeZ, this.texWidth, this.texHeight);
            this.polygons[3].flipNormal = true;
        } else {
            this.polygons[3] = new Polygon(new Vertex[]{ptvMaxXMaxYMinZ, ptvMinXMaxYMinZ, ptvMinXMaxYMaxZ, ptvMaxXMaxYMaxZ}, this.textureU + sizeZ + sizeX, this.textureV, this.textureU + sizeZ + sizeX + sizeX, this.textureV + sizeZ, this.texWidth, this.texHeight);
        }
        this.polygons[4] = new Polygon(new Vertex[]{ptvMaxXMinYMinZ, ptvMinXMinYMinZ, ptvMinXMaxYMinZ, ptvMaxXMaxYMinZ}, this.textureU + sizeZ, this.textureV + sizeZ, this.textureU + sizeZ + sizeX, this.textureV + sizeZ + sizeY, this.texWidth, this.texHeight);
        this.polygons[5] = new Polygon(new Vertex[]{ptvMinXMinYMaxZ, ptvMaxXMinYMaxZ, ptvMaxXMaxYMaxZ, ptvMinXMaxYMaxZ}, this.textureU + sizeZ + sizeX + sizeZ, this.textureV + sizeZ, this.textureU + sizeZ + sizeX + sizeZ + sizeX, this.textureV + sizeZ + sizeY, this.texWidth, this.texHeight);
        if (this.mirror) {
            for (Polygon face : this.polygons) {
                face.mirror();
            }
        }
    }

    public void setRotationPoint(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void setRotationAngle(float x, float y, float z) {
        this.xRot = x;
        this.yRot = y;
        this.zRot = z;
    }

    public void render(float scale) {
        if (this.neverRender) {
            return;
        }
        if (!this.visible) {
            return;
        }
        if (!this.compiled) {
            this.compile(scale);
        }
        if (this.xRot != 0.0f || this.yRot != 0.0f || this.zRot != 0.0f) {
            GL11.glPushMatrix();
            GL11.glTranslatef(this.x * scale, this.y * scale, this.z * scale);
            if (this.zRot != 0.0f) {
                GL11.glRotatef(this.zRot * 57.29578f, 0.0f, 0.0f, 1.0f);
            }
            if (this.yRot != 0.0f) {
                GL11.glRotatef(this.yRot * 57.29578f, 0.0f, 1.0f, 0.0f);
            }
            if (this.xRot != 0.0f) {
                GL11.glRotatef(this.xRot * 57.29578f, 1.0f, 0.0f, 0.0f);
            }
            GL11.glCallList(this.displayList);
            GL11.glPopMatrix();
        } else if (this.x != 0.0f || this.y != 0.0f || this.z != 0.0f) {
            GL11.glTranslatef(this.x * scale, this.y * scale, this.z * scale);
            GL11.glCallList(this.displayList);
            GL11.glTranslatef(-this.x * scale, -this.y * scale, -this.z * scale);
        } else {
            GL11.glCallList(this.displayList);
        }
    }

    public void renderWithRotation(float scale) {
        if (this.neverRender) {
            return;
        }
        if (!this.visible) {
            return;
        }
        if (!this.compiled) {
            this.compile(scale);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef(this.x * scale, this.y * scale, this.z * scale);
        if (this.yRot != 0.0f) {
            GL11.glRotatef(this.yRot * 57.29578f, 0.0f, 1.0f, 0.0f);
        }
        if (this.xRot != 0.0f) {
            GL11.glRotatef(this.xRot * 57.29578f, 1.0f, 0.0f, 0.0f);
        }
        if (this.zRot != 0.0f) {
            GL11.glRotatef(this.zRot * 57.29578f, 0.0f, 0.0f, 1.0f);
        }
        GL11.glCallList(this.displayList);
        GL11.glPopMatrix();
    }

    public void translateTo(float scale) {
        if (this.neverRender) {
            return;
        }
        if (!this.visible) {
            return;
        }
        if (!this.compiled) {
            this.compile(scale);
        }
        if (this.xRot != 0.0f || this.yRot != 0.0f || this.zRot != 0.0f) {
            GL11.glTranslatef(this.x * scale, this.y * scale, this.z * scale);
            if (this.zRot != 0.0f) {
                GL11.glRotatef(this.zRot * 57.29578f, 0.0f, 0.0f, 1.0f);
            }
            if (this.yRot != 0.0f) {
                GL11.glRotatef(this.yRot * 57.29578f, 0.0f, 1.0f, 0.0f);
            }
            if (this.xRot != 0.0f) {
                GL11.glRotatef(this.xRot * 57.29578f, 1.0f, 0.0f, 0.0f);
            }
        } else if (this.x != 0.0f || this.y != 0.0f || this.z != 0.0f) {
            GL11.glTranslatef(this.x * scale, this.y * scale, this.z * scale);
        }
    }

    private void compile(float scale) {
        this.displayList = GLAllocation.generateDisplayLists(1);
        GL11.glNewList(this.displayList, 4864);
        Tessellator tessellator = Tessellator.instance;
        for (Polygon polygon : this.polygons) {
            polygon.render(tessellator, scale);
        }
        GL11.glEndList();
        this.compiled = true;
    }

    public Polygon[] getPolygons() {
        return this.polygons;
    }

    public Vertex[] getVertices() {
        return this.vertices;
    }
}

