/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.dynamictexture;

import net.minecraft.client.render.dynamictexture.DynamicTexture;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import org.jetbrains.annotations.NotNull;

public class DynamicTextureFire
extends DynamicTexture {
    protected float[] arr1;
    protected float[] arr2;
    private int height;
    private float scaleFactor;

    public DynamicTextureFire(@NotNull IconCoordinate targetTexture) {
        super(targetTexture);
    }

    @Override
    public void postInit() {
        this.initTexture();
        this.scaleFactor = (float)this.targetTexture.height / 16.0f;
        this.height = (int)(20.0f * this.scaleFactor);
        this.arr1 = new float[this.targetTexture.width * (this.height + 4)];
        this.arr2 = new float[this.targetTexture.width * (this.height + 4)];
    }

    @Override
    public void update() {
        for (int x = 0; x < this.targetTexture.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                int var3 = (int)(15.0f * this.scaleFactor);
                float bright = this.arr1[x + (y + 1) % this.height * this.targetTexture.width] * (float)var3;
                for (int k = x - 1; k <= x + 1; ++k) {
                    for (int l = y; l <= y + 1; ++l) {
                        if (k >= 0 && l >= 0 && k < this.targetTexture.width && l < this.height) {
                            bright += this.arr1[k + l * this.targetTexture.width];
                        }
                        ++var3;
                    }
                }
                this.arr2[x + y * this.targetTexture.width] = bright / ((float)var3 * (1.0f + 0.06f / this.scaleFactor));
                if (!((float)y >= 17.0f * this.scaleFactor)) continue;
                this.arr2[x + y * this.targetTexture.width] = (float)(Math.random() * Math.random() * Math.random() * 4.0 + Math.random() * 0.1 + 0.2);
            }
        }
        float[] _arr2 = this.arr2;
        this.arr2 = this.arr1;
        this.arr1 = _arr2;
        for (int i = 0; i < this.targetTexture.width * this.targetTexture.height; ++i) {
            float l = this.arr1[i] * 1.8f;
            if (l > 1.0f) {
                l = 1.0f;
            }
            if (l < 0.0f) {
                l = 0.0f;
            }
            int r = (int)(l * 155.0f + 100.0f);
            int g = (int)(l * l * 255.0f);
            int b = (int)(l * l * l * l * l * l * l * l * l * l * 255.0f);
            int a = 255;
            if (l < 0.5f) {
                a = 0;
            }
            this.imageData[i * 4 + 0] = (byte)r;
            this.imageData[i * 4 + 1] = (byte)g;
            this.imageData[i * 4 + 2] = (byte)b;
            this.imageData[i * 4 + 3] = (byte)a;
        }
    }
}

