/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.tessellator.Tessellator;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class ScrolledSelectionList {
    private final Minecraft minecraft;
    private final int width;
    private final int height;
    protected final int y0;
    protected final int y1;
    protected final int x1;
    protected final int x0 = 0;
    protected final int itemHeight;
    private float yDrag = -2.0f;
    private float scrollMultiplier;
    private float amountScrolled;
    private int selectedElement = -1;
    private long lastClicked = 0L;
    private boolean renderSelection = true;
    private boolean renderHeader;
    private int headerHeight;

    public ScrolledSelectionList(Minecraft minecraft, int width, int height, int y0, int y1, int itemHeight) {
        this.minecraft = minecraft;
        this.width = width;
        this.height = height;
        this.y0 = y0;
        this.y1 = y1;
        this.itemHeight = itemHeight;
        this.x1 = width;
    }

    public void setRenderSelection(boolean renderSelection) {
        this.renderSelection = renderSelection;
    }

    protected void setRenderHeader(boolean renderHeader, int headerHeight) {
        this.renderHeader = renderHeader;
        this.headerHeight = headerHeight;
        if (!renderHeader) {
            this.headerHeight = 0;
        }
    }

    protected abstract int getItemCount();

    protected abstract void selectItem(int var1, boolean var2);

    protected abstract boolean isSelectedItem(int var1);

    protected int getMaxPosition() {
        return this.getItemCount() * this.itemHeight + this.headerHeight;
    }

    protected abstract void renderHoleBackground();

    protected abstract void renderItem(int var1, int var2, int var3, int var4, Tessellator var5);

    protected void renderHeader(int x, int y, Tessellator tessellator) {
    }

    protected void clickedHeader(int x, int y) {
    }

    protected void renderDecorations(int x, int y) {
    }

    public int getItemAtPosition(int x, int y) {
        int xMin = this.width / 2 - 110;
        int xMax = this.width / 2 + 110;
        int yMin = y - this.y0 - this.headerHeight + (int)this.amountScrolled - 4;
        int yMax = yMin / this.itemHeight;
        if (x >= xMin && x <= xMax && yMax >= 0 && yMin >= 0 && yMax < this.getItemCount()) {
            return yMax;
        }
        return -1;
    }

    private void capYPosition() {
        int maxAmountScrolled = this.getMaxPosition() - (this.y1 - this.y0 - 4);
        if (maxAmountScrolled < 0) {
            maxAmountScrolled /= 2;
        }
        if (this.amountScrolled < 0.0f) {
            this.amountScrolled = 0.0f;
        }
        if (this.amountScrolled > (float)maxAmountScrolled) {
            this.amountScrolled = maxAmountScrolled;
        }
    }

    public void render(int x, int y, float partialTicks) {
        this.renderHoleBackground();
        int numItems = this.getItemCount();
        int scrollbarLeft = this.width / 2 + 124;
        int scrollbarRight = scrollbarLeft + 6;
        if (this.minecraft.controllerInput != null && Math.abs(this.minecraft.controllerInput.joyRight.getY()) > 0.1f) {
            this.amountScrolled += this.minecraft.controllerInput.joyRight.getY();
        }
        if (Mouse.isButtonDown(0) || this.minecraft.controllerInput != null && this.minecraft.controllerInput.buttonA.isPressed()) {
            if (this.yDrag == -1.0f) {
                boolean flag = true;
                if (y >= this.y0 && y <= this.y1) {
                    int left = this.width / 2 - 110;
                    int right = this.width / 2 + 110;
                    int i2 = y - this.y0 - this.headerHeight + (int)this.amountScrolled - 4;
                    int k2 = i2 / this.itemHeight;
                    if (x >= left && x <= right && k2 >= 0 && i2 >= 0 && k2 < numItems) {
                        boolean flag1 = k2 == this.selectedElement && System.currentTimeMillis() - this.lastClicked < 250L;
                        this.selectItem(k2, flag1);
                        this.selectedElement = k2;
                        this.lastClicked = System.currentTimeMillis();
                    } else if (x >= left && x <= right && i2 < 0) {
                        this.clickedHeader(x - left, y - this.y0 + (int)this.amountScrolled - 4);
                        flag = false;
                    }
                    if (x >= scrollbarLeft && x <= scrollbarRight && this.getMaxPosition() != 0) {
                        int l3;
                        this.scrollMultiplier = -1.0f;
                        int i3 = this.getMaxPosition() - (this.y1 - this.y0 - 4);
                        if (i3 < 1) {
                            i3 = 1;
                        }
                        if ((l3 = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition())) < 32) {
                            l3 = 32;
                        }
                        if (l3 > this.y1 - this.y0 - 8) {
                            l3 = this.y1 - this.y0 - 8;
                        }
                        this.scrollMultiplier /= (float)(this.y1 - this.y0 - l3) / (float)i3;
                    } else {
                        this.scrollMultiplier = 1.0f;
                    }
                    this.yDrag = flag ? (float)y : -2.0f;
                } else {
                    this.yDrag = -2.0f;
                }
            } else if (this.yDrag >= 0.0f) {
                this.amountScrolled -= ((float)y - this.yDrag) * this.scrollMultiplier;
                this.yDrag = y;
            }
        } else {
            this.yDrag = -1.0f;
        }
        this.amountScrolled -= (float)Mouse.getDWheel() * 20.0f;
        this.capYPosition();
        GL11.glDisable(2896);
        GL11.glDisable(2912);
        Tessellator tessellator = Tessellator.instance;
        this.minecraft.textureManager.loadTexture("/assets/minecraft/textures/gui/background.png").bind();
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        float f1 = 32.0f;
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0x202020);
        tessellator.addVertexWithUV(0.0, this.y1, 0.0, 0.0f / f1, (float)(this.y1 + (int)this.amountScrolled) / f1);
        tessellator.addVertexWithUV(this.x1, this.y1, 0.0, (float)this.x1 / f1, (float)(this.y1 + (int)this.amountScrolled) / f1);
        tessellator.addVertexWithUV(this.x1, this.y0, 0.0, (float)this.x1 / f1, (float)(this.y0 + (int)this.amountScrolled) / f1);
        tessellator.addVertexWithUV(0.0, this.y0, 0.0, 0.0f / f1, (float)(this.y0 + (int)this.amountScrolled) / f1);
        tessellator.draw();
        int ix = this.width / 2 - 92 - 16;
        int j2 = this.y0 + 4 - (int)this.amountScrolled;
        if (this.renderHeader) {
            this.renderHeader(ix, j2, tessellator);
        }
        for (int itemIndex = 0; itemIndex < numItems; ++itemIndex) {
            int iy = j2 + itemIndex * this.itemHeight + this.headerHeight;
            int height = this.itemHeight - 4;
            if (iy > this.y1 || iy + height < this.y0) continue;
            if (this.renderSelection && this.isSelectedItem(itemIndex)) {
                int minX = this.width / 2 - 110;
                int maxX = this.width / 2 + 110;
                GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                GL11.glDisable(3553);
                tessellator.startDrawingQuads();
                tessellator.setColorOpaque_I(0x808080);
                tessellator.addVertexWithUV(minX, iy + height + 2, 0.0, 0.0, 1.0);
                tessellator.addVertexWithUV(maxX, iy + height + 2, 0.0, 1.0, 1.0);
                tessellator.addVertexWithUV(maxX, iy - 2, 0.0, 1.0, 0.0);
                tessellator.addVertexWithUV(minX, iy - 2, 0.0, 0.0, 0.0);
                tessellator.setColorOpaque_I(0);
                tessellator.addVertexWithUV(minX + 1, iy + height + 1, 0.0, 0.0, 1.0);
                tessellator.addVertexWithUV(maxX - 1, iy + height + 1, 0.0, 1.0, 1.0);
                tessellator.addVertexWithUV(maxX - 1, iy - 1, 0.0, 1.0, 0.0);
                tessellator.addVertexWithUV(minX + 1, iy - 1, 0.0, 0.0, 0.0);
                tessellator.draw();
                GL11.glEnable(3553);
            }
            this.renderItem(itemIndex, ix, iy, height, tessellator);
        }
        GL11.glDisable(2929);
        int byte0 = 4;
        this.renderHoleBackground(0, this.y0, 255, 255);
        this.renderHoleBackground(this.y1, this.height, 255, 255);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        GL11.glDisable(3008);
        GL11.glShadeModel(7425);
        GL11.glDisable(3553);
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_I(0, 0);
        tessellator.addVertexWithUV(0.0, this.y0 + byte0, 0.0, 0.0, 1.0);
        tessellator.addVertexWithUV(this.x1, this.y0 + byte0, 0.0, 1.0, 1.0);
        tessellator.setColorRGBA_I(0, 255);
        tessellator.addVertexWithUV(this.x1, this.y0, 0.0, 1.0, 0.0);
        tessellator.addVertexWithUV(0.0, this.y0, 0.0, 0.0, 0.0);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_I(0, 255);
        tessellator.addVertexWithUV(0.0, this.y1, 0.0, 0.0, 1.0);
        tessellator.addVertexWithUV(this.x1, this.y1, 0.0, 1.0, 1.0);
        tessellator.setColorRGBA_I(0, 0);
        tessellator.addVertexWithUV(this.x1, this.y1 - byte0, 0.0, 1.0, 0.0);
        tessellator.addVertexWithUV(0.0, this.y1 - byte0, 0.0, 0.0, 0.0);
        tessellator.draw();
        int k3 = this.getMaxPosition() - (this.y1 - this.y0 - 4);
        if (k3 > 0 && this.getMaxPosition() != 0) {
            int l4;
            int j4 = (this.y1 - this.y0) * (this.y1 - this.y0) / this.getMaxPosition();
            if (j4 < 32) {
                j4 = 32;
            }
            if (j4 > this.y1 - this.y0 - 8) {
                j4 = this.y1 - this.y0 - 8;
            }
            if ((l4 = (int)this.amountScrolled * (this.y1 - this.y0 - j4) / k3 + this.y0) < this.y0) {
                l4 = this.y0;
            }
            tessellator.startDrawingQuads();
            tessellator.setColorRGBA_I(0, 255);
            tessellator.addVertexWithUV(scrollbarLeft, this.y1, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(scrollbarRight, this.y1, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV(scrollbarRight, this.y0, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(scrollbarLeft, this.y0, 0.0, 0.0, 0.0);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setColorRGBA_I(0x808080, 255);
            tessellator.addVertexWithUV(scrollbarLeft, l4 + j4, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(scrollbarRight, l4 + j4, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV(scrollbarRight, l4, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(scrollbarLeft, l4, 0.0, 0.0, 0.0);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setColorRGBA_I(0xC0C0C0, 255);
            tessellator.addVertexWithUV(scrollbarLeft, l4 + j4 - 1, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(scrollbarRight - 1, l4 + j4 - 1, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV(scrollbarRight - 1, l4, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(scrollbarLeft, l4, 0.0, 0.0, 0.0);
            tessellator.draw();
        }
        this.renderDecorations(x, y);
        GL11.glEnable(3553);
        GL11.glShadeModel(7424);
        GL11.glEnable(3008);
        GL11.glDisable(3042);
    }

    private void renderHoleBackground(int y0, int y1, int a0, int a1) {
        Tessellator tessellator = Tessellator.instance;
        this.minecraft.textureManager.loadTexture("/assets/minecraft/textures/gui/background.png").bind();
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        float f = 32.0f;
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_I(0x404040, a1);
        tessellator.addVertexWithUV(0.0, y1, 0.0, 0.0, (float)y1 / f);
        tessellator.addVertexWithUV(this.width, y1, 0.0, (float)this.width / f, (float)y1 / f);
        tessellator.setColorRGBA_I(0x404040, a0);
        tessellator.addVertexWithUV(this.width, y0, 0.0, (float)this.width / f, (float)y0 / f);
        tessellator.addVertexWithUV(0.0, y0, 0.0, 0.0, (float)y0 / f);
        tessellator.draw();
    }
}

