/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.particle;

import net.minecraft.client.entity.particle.Particle;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.world.World;

public class ParticleExplode
extends Particle {
    public ParticleExplode(World world, double x, double y, double z, double xa, double ya, double za) {
        super(world, x, y, z, xa, ya, za);
        this.xd = xa + (Math.random() * 2.0 - 1.0) * (double)0.05f;
        this.yd = ya + (Math.random() * 2.0 - 1.0) * (double)0.05f;
        this.zd = za + (Math.random() * 2.0 - 1.0) * (double)0.05f;
        this.gCol = this.bCol = this.random.nextFloat() * 0.3f + 0.7f;
        this.rCol = this.bCol;
        this.size = this.random.nextFloat() * this.random.nextFloat() * 6.0f + 1.0f;
        this.lifetime = (int)(16.0 / ((double)this.random.nextFloat() * 0.8 + 0.2)) + 2;
    }

    @Override
    public void tick() {
        int val;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.tex = (val = 7 - this.age * 8 / this.lifetime) >= 0 ? TextureRegistry.getTexture("minecraft:particle/puff_" + val) : null;
        this.yd += 0.004;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= 0.9;
        this.yd *= 0.9;
        this.zd *= 0.9;
        if (this.onGround) {
            this.xd *= 0.7;
            this.zd *= 0.7;
        }
    }
}

