/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.particle;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.particle.ParticleArrowGolden;
import net.minecraft.client.entity.particle.ParticleBlockBreaking;
import net.minecraft.client.entity.particle.ParticleBubble;
import net.minecraft.client.entity.particle.ParticleExplode;
import net.minecraft.client.entity.particle.ParticleFirefly;
import net.minecraft.client.entity.particle.ParticleFlame;
import net.minecraft.client.entity.particle.ParticleFluidDrip;
import net.minecraft.client.entity.particle.ParticleFootstep;
import net.minecraft.client.entity.particle.ParticleHeart;
import net.minecraft.client.entity.particle.ParticleItemBreaking;
import net.minecraft.client.entity.particle.ParticleLambda;
import net.minecraft.client.entity.particle.ParticleLava;
import net.minecraft.client.entity.particle.ParticleLeaf;
import net.minecraft.client.entity.particle.ParticleNote;
import net.minecraft.client.entity.particle.ParticlePortal;
import net.minecraft.client.entity.particle.ParticlePuffRGB;
import net.minecraft.client.entity.particle.ParticleRedstoneDust;
import net.minecraft.client.entity.particle.ParticleSlimeChunk;
import net.minecraft.client.entity.particle.ParticleSmoke;
import net.minecraft.client.entity.particle.ParticleSnowShovel;
import net.minecraft.client.entity.particle.ParticleSplash;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.util.dispatch.Dispatcher;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.animal.MobFireflyCluster;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.BlockParticleHelper;
import net.minecraft.core.util.helper.MathHelper;

public final class ParticleDispatcher
extends Dispatcher<String, ParticleLambda> {
    private static ParticleDispatcher INSTANCE = new ParticleDispatcher();
    private static final ParticleLambda BLANK = (world, x, y, z, motionX, motionY, motionZ, data) -> null;

    public static ParticleDispatcher getInstance() {
        return INSTANCE;
    }

    public List<String> getParticleIds() {
        return new ArrayList<String>(this.dispatches.keySet());
    }

    @Override
    protected ParticleLambda getDefault() {
        return BLANK;
    }

    private ParticleDispatcher() {
        INSTANCE = this;
        Minecraft mc = Minecraft.getMinecraft();
        this.addDispatch("bubble", (world, x, y, z, motionX, motionY, motionZ, data) -> new ParticleBubble(world, x, y, z, motionX, motionY, motionZ, true));
        this.addDispatch("smoke", (world, x, y, z, motionX, motionY, motionZ, data) -> new ParticleSmoke(world, x, y, z, motionX, motionY, motionX));
        this.addDispatch("note", (world, x, y, z, motionX, motionY, motionZ, data) -> new ParticleNote(world, x, y, z, motionX, motionY, motionX, data));
        this.addDispatch("portal", (world, x, y, z, motionX, motionY, motionZ, data) -> new ParticlePortal(world, x, y, z, motionX, motionY, motionX, data));
        this.addDispatch("explode", (world, x, y, z, motionX, motionY, motionZ, data) -> new ParticleExplode(world, x, y, z, motionX, motionY, motionX));
        this.addDispatch("flame", (world, x, y, z, motionX, motionY, motionZ, data) -> new ParticleFlame(world, x, y, z, motionX, motionY, motionX, ParticleFlame.Type.ORANGE));
        this.addDispatch("blueflame", (world, x, y, z, motionX, motionY, motionZ, data) -> new ParticleFlame(world, x, y, z, motionX, motionY, motionX, ParticleFlame.Type.BLUE));
        this.addDispatch("soulflame", (world, x, y, z, motionX, motionY, motionZ, data) -> new ParticleFlame(world, x, y, z, motionX, motionY, motionX, ParticleFlame.Type.SOUL));
        this.addDispatch("lava", (world, x, y, z, motionX, motionY, motionZ, data) -> new ParticleLava(world, x, y, z));
        this.addDispatch("footstep", (world, x, y, z, motionX, motionY, motionZ, data) -> new ParticleFootstep(mc.textureManager, world, x, y, z));
        this.addDispatch("splash", (world1, d, d1, d2, d3, d4, d5, data) -> new ParticleSplash(world1, d, d1, d2, d3, d4, d5));
        this.addDispatch("largesmoke", (world, x, y, z, motionX, motionY, motionZ, data) -> new ParticleSmoke(world, x, y, z, motionX, motionY, motionX, 2.5f));
        this.addDispatch("puffrgb", (world, x, y, z, motionX, motionY, motionZ, data) -> new ParticlePuffRGB(world, x, y, z, (float)motionX, (float)motionY, (float)motionZ, data));
        this.addDispatch("reddust", (world, x, y, z, motionX, motionY, motionZ, data) -> new ParticleRedstoneDust(world, x, y, z, data));
        this.addDispatch("item", (world, x, y, z, motionX, motionY, motionZ, data) -> new ParticleItemBreaking(world, x, y, z, Item.itemsList[MathHelper.clamp(data, 0, Item.itemsList.length - 1)]));
        this.addDispatch("block", (world, x, y, z, motionX, motionY, motionZ, data) -> new ParticleBlockBreaking(world, x, y, z, motionX, motionY, motionZ, Blocks.blocksList[BlockParticleHelper.decodeBlockID(data)], BlockParticleHelper.decodeBlockSide(data), BlockParticleHelper.decodeBlockMeta(data)).init((int)x, (int)y, (int)z));
        this.addDispatch("snowshovel", (world, x, y, z, motionX, motionY, motionZ, data) -> new ParticleSnowShovel(world, x, y, z, motionX, motionY, motionX));
        this.addDispatch("heart", (world, x, y, z, motionX, motionY, motionZ, data) -> new ParticleHeart(world, x, y, z, motionX, motionY, motionX));
        this.addDispatch("slimechunk", (world, x, y, z, motionX, motionY, motionZ, data) -> {
            if (((Boolean)mc.gameSettings.slimeParticles.value).booleanValue()) {
                return new ParticleSlimeChunk(world, x, y, z, Items.SLIMEBALL);
            }
            return null;
        });
        this.addDispatch("fireflyGreen", (world, x, y, z, motionX, motionY, motionZ, data) -> new ParticleFirefly(world, x, y, z, motionX, motionY, motionX, MobFireflyCluster.FireflyColor.GREEN.getId()));
        this.addDispatch("fireflyBlue", (world, x, y, z, motionX, motionY, motionZ, data) -> new ParticleFirefly(world, x, y, z, motionX, motionY, motionX, MobFireflyCluster.FireflyColor.BLUE.getId()));
        this.addDispatch("fireflyOrange", (world, x, y, z, motionX, motionY, motionZ, data) -> new ParticleFirefly(world, x, y, z, motionX, motionY, motionX, MobFireflyCluster.FireflyColor.ORANGE.getId()));
        this.addDispatch("fireflyRed", (world, x, y, z, motionX, motionY, motionZ, data) -> new ParticleFirefly(world, x, y, z, motionX, motionY, motionX, MobFireflyCluster.FireflyColor.RED.getId()));
        this.addDispatch("arrowtrail", (world, x, y, z, motionX, motionY, motionZ, data) -> new ParticleArrowGolden(world, x, y, z, motionX, motionY, motionX));
        this.addDispatch("fallingleaf", (world, x, y, z, motionX, motionY, motionZ, data) -> {
            int id = world.getBlockId(MathHelper.floor(x), MathHelper.floor(y), MathHelper.floor(z));
            if (id != 0) {
                return new ParticleLeaf(world, x, y, z, motionX, motionY, motionX).init(MathHelper.floor(x), MathHelper.floor(y), MathHelper.floor(z));
            }
            return null;
        });
        this.addDispatch("dripWater", (world, x, y, z, motionX, motionY, motionZ, data) -> {
            int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(Blocks.FLUID_WATER_STILL)).getWorldColor(world, MathHelper.floor(x), MathHelper.floor(y), MathHelper.floor(z));
            return new ParticleFluidDrip(world, x, y, z, color, TextureRegistry.getTexture("minecraft:block/water_flowing"));
        });
        this.addDispatch("dripLava", (world, x, y, z, motionX, motionY, motionZ, data) -> new ParticleFluidDrip(world, x, y, z, 0xFFFFFF, TextureRegistry.getTexture("minecraft:block/lava_flowing")).setFullBright());
    }
}

