/*
 * Decompiled with CFR 0.152.
 */
package turniplabs.halplibe.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;

public class DirectoryManager {
    public static final HashMap<String, HashMap<String, String>> resourceDirectoryMap = new HashMap();
    public static final List<String> allKeys = new ArrayList<String>();
    public static final String BLOCK_TEXTURES = DirectoryManager.registerKey("halplibe:block_textures");
    public static final String ITEM_TEXTURES = DirectoryManager.registerKey("halplibe:item_textures");
    public static final String PARTICLE_TEXTURES = DirectoryManager.registerKey("halplibe:particle_textures");
    public static final String LANGUAGE = DirectoryManager.registerKey("halplibe:language");
    public static final String SOUND = DirectoryManager.registerKey("halplibe:sound");
    public static final String MUSIC = DirectoryManager.registerKey("halplibe:music");
    public static final String STREAMING = DirectoryManager.registerKey("halplibe:streaming");
    public static final String CAVE_MUSIC = DirectoryManager.registerKey("halplibe:cave_music");
    public static final String ARMOR = DirectoryManager.registerKey("halplibe:armor");
    public static final FabricLoader fl = FabricLoader.getInstance();

    public static void refreshDirectories() {
        for (ModContainer container : fl.getAllMods()) {
            String id = container.getMetadata().getId();
            ModMetadata metadata = container.getMetadata();
            for (String key : allKeys) {
                if (!metadata.containsCustomValue(key)) continue;
                DirectoryManager.assignDirectory(key, id, metadata.getCustomValue(key).getAsString());
            }
        }
    }

    public static String registerKey(String key) {
        allKeys.add(key);
        return key;
    }

    public static void assignDirectory(String key, String modID, String path) {
        resourceDirectoryMap.putIfAbsent(modID, new HashMap());
        resourceDirectoryMap.get(modID).put(key, path);
    }

    public static String getDirectory(String key, String modID, String formattedDefault) {
        resourceDirectoryMap.putIfAbsent(modID, new HashMap());
        return resourceDirectoryMap.get(modID).getOrDefault(key, String.format(formattedDefault, modID));
    }

    public static String getBlockTextureDirectory(String modID) {
        return DirectoryManager.getDirectory(BLOCK_TEXTURES, modID, "/assets/%s/textures/block/");
    }

    public static String getItemTextureDirectory(String modID) {
        return DirectoryManager.getDirectory(ITEM_TEXTURES, modID, "/assets/%s/textures/item/");
    }

    public static String getParticleTextureDirectory(String modID) {
        return DirectoryManager.getDirectory(PARTICLE_TEXTURES, modID, "/assets/%s/textures/particle/");
    }

    public static String getLanguageDirectory(String modID) {
        return DirectoryManager.getDirectory(LANGUAGE, modID, "/lang/%s/");
    }

    public static String getSoundDirectory(String modID) {
        return DirectoryManager.getDirectory(SOUND, modID, "/assets/%s/sound/");
    }

    public static String getMusicDirectory(String modID) {
        return DirectoryManager.getDirectory(MUSIC, modID, "/assets/%s/music/");
    }

    public static String getCaveMusicDirectory(String modID) {
        return DirectoryManager.getDirectory(CAVE_MUSIC, modID, "/assets/%s/cavemusic/");
    }

    public static String getStreamingDirectory(String modID) {
        return DirectoryManager.getDirectory(STREAMING, modID, "/assets/%s/streaming/");
    }

    public static String getArmorDirectory(String modID) {
        return DirectoryManager.getDirectory(ARMOR, modID, "/assets/%s/textures/armor/");
    }

    static {
        DirectoryManager.refreshDirectories();
    }
}

