/*
 * Decompiled with CFR 0.152.
 */
package b100.minimap.mc.impl;

import b100.minimap.Minimap;
import b100.minimap.render.block.TileColors;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.Option;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.texture.stitcher.AtlasStitcher;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class TileColorsBTA
extends TileColors {
    public static final TileColorsBTA instance = new TileColorsBTA(Minecraft.getMinecraft());
    public Minecraft mc;
    public final Map<IconCoordinate, Integer> mapColors = new HashMap<IconCoordinate, Integer>();

    private TileColorsBTA(Minecraft minecraft) {
        this.mc = minecraft;
    }

    @Override
    public void createTileColors() {
        this.mapColors.clear();
        AtlasStitcher atlas = TextureRegistry.blockAtlas;
        BufferedImage atlasImage = atlas.atlas;
        HashSet allTextures = new HashSet();
        allTextures.addAll(atlas.textureMap.values());
        for (IconCoordinate texture : allTextures) {
            this.mapColors.put(texture, this.getAverageColor(atlasImage, texture.iconX, texture.iconY, texture.width, texture.height, 0));
        }
        int waterColorOverride = (Boolean)this.mc.gameSettings.biomeWater.value != false ? -8355712 : -15193857;
        IconCoordinate water_still = (IconCoordinate)TextureRegistry.blockAtlas.textureMap.get("minecraft:water_still");
        IconCoordinate water_flowing = (IconCoordinate)TextureRegistry.blockAtlas.textureMap.get("minecraft:water_flowing");
        this.mapColors.put(water_still, waterColorOverride);
        this.mapColors.put(water_flowing, waterColorOverride);
    }

    @Override
    public int getTileColor(World world, int x, int y, int z, Block block) {
        BlockModel model = (BlockModel)BlockModelDispatcher.getInstance().getDispatch((Object)block);
        IconCoordinate texture = model.getBlockTextureFromSideAndMetadata(Side.TOP, world.getBlockMetadata(x, y, z));
        Integer color = this.mapColors.get(texture);
        if (color == null) {
            return 0xFFFFFF;
        }
        return color;
    }

    public void onOptionValueChanged(GameSettings settings, Option<?> option) {
        if (option == settings.biomeWater) {
            this.createTileColors();
            Minimap.instance.mapRender.updateAllTiles();
        }
    }
}

