/*
 * Decompiled with CFR 0.152.
 */
package b100.minimap.gui.waypoint;

import b100.minimap.gui.ColorListener;
import b100.minimap.gui.GuiButton;
import b100.minimap.gui.GuiButtonNavigation;
import b100.minimap.gui.GuiColorSelectScreen;
import b100.minimap.gui.GuiContainerBox;
import b100.minimap.gui.GuiElement;
import b100.minimap.gui.GuiNavigationContainer;
import b100.minimap.gui.GuiScreen;
import b100.minimap.gui.GuiTextComponent;
import b100.minimap.gui.GuiTextComponentInteger;
import b100.minimap.gui.GuiTextElement;
import b100.minimap.gui.GuiTextField;
import b100.minimap.gui.TextComponentListener;
import b100.minimap.gui.waypoint.GuiWaypointColorButton;
import b100.minimap.mc.IPlayer;
import b100.minimap.waypoint.Waypoint;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.input.Keyboard;

public abstract class GuiEditWaypointBase
extends GuiScreen
implements TextComponentListener,
ColorListener {
    public String title;
    public Waypoint waypoint;
    public GuiNavigationContainer navTop;
    public GuiNavigationContainer navBottom;
    public GuiContainerBox container;
    public GuiTextField textFieldName;
    public GuiTextField textFieldPosX;
    public GuiTextField textFieldPosY;
    public GuiTextField textFieldPosZ;
    public GuiTextComponentInteger textComponentX;
    public GuiTextComponentInteger textComponentY;
    public GuiTextComponentInteger textComponentZ;
    public GuiTextElement textName;
    public GuiTextElement textOffset;
    public GuiTextElement textX;
    public GuiTextElement textY;
    public GuiTextElement textZ;
    public GuiTextElement textColor;
    public GuiButton colorButton;
    public int playerOffsetX;
    public int playerOffsetY;
    public int playerOffsetZ;

    public GuiEditWaypointBase(GuiScreen parentScreen) {
        super(parentScreen);
        this.setPlayerOffset();
    }

    public void setPlayerOffset() {
        IPlayer player = this.minimap.minecraftHelper.getThePlayer();
        this.playerOffsetX = MathHelper.floor((double)player.getPosX(1.0f));
        this.playerOffsetY = MathHelper.floor((double)player.getPosY(1.0f));
        this.playerOffsetZ = MathHelper.floor((double)player.getPosZ(1.0f));
    }

    @Override
    public void onInit() {
        this.container = this.add(new GuiContainerBox());
        this.navTop = this.add(new GuiNavigationContainer(this, this.container, GuiNavigationContainer.Position.TOP));
        this.navBottom = this.add(new GuiNavigationContainer(this, this.container, GuiNavigationContainer.Position.BOTTOM));
        this.navTop.add(new GuiButtonNavigation(this, this.title, this.container));
        this.navBottom.add(new GuiButtonNavigation(this, "Cancel", this.container).addActionListener(e -> this.cancel()));
        this.navBottom.add(new GuiButtonNavigation(this, "OK", this.container).addActionListener(e -> this.ok()));
        this.textComponentX = new GuiTextComponentInteger(this.waypoint.x - this.playerOffsetX);
        this.textComponentY = new GuiTextComponentInteger(this.waypoint.y - this.playerOffsetY);
        this.textComponentZ = new GuiTextComponentInteger(this.waypoint.z - this.playerOffsetZ);
        this.textFieldName = this.container.add(new GuiTextField((GuiScreen)this, this.waypoint.name));
        this.textFieldPosX = this.container.add(new GuiTextField((GuiScreen)this, this.textComponentX));
        this.textFieldPosY = this.container.add(new GuiTextField((GuiScreen)this, this.textComponentY));
        this.textFieldPosZ = this.container.add(new GuiTextField((GuiScreen)this, this.textComponentZ));
        this.textName = this.add(new GuiTextElement("Name"));
        this.textOffset = this.add(new GuiTextElement("Offset"));
        this.textX = this.add(new GuiTextElement("x"));
        this.textY = this.add(new GuiTextElement("y"));
        this.textZ = this.add(new GuiTextElement("z"));
        this.textColor = this.add(new GuiTextElement("Color"));
        this.textFieldName.textComponent.addTextComponentListener(this);
        this.textFieldPosX.textComponent.addTextComponentListener(this);
        this.textFieldPosY.textComponent.addTextComponentListener(this);
        this.textFieldPosZ.textComponent.addTextComponentListener(this);
        this.textFieldName.textComponent.setFocused(true);
        this.colorButton = this.add(new GuiWaypointColorButton((GuiScreen)this, this.waypoint)).addActionListener(e -> this.utils.displayGui(new GuiColorSelectScreen(this, this.waypoint.color, this)));
    }

    @Override
    public void onResize() {
        int paddingOuter = 2;
        boolean paddingInner = true;
        int lineHeight = 10;
        int lineHeightPad = 11;
        int w = 150;
        int h = 69;
        this.container.setSize(w, h);
        this.container.setPosition((this.width - w) / 2, (this.height - h) / 2);
        int innerWidth = w - 4;
        int posXInner = this.container.posX + 2;
        int posYInner = this.container.posY + 2;
        this.textName.setPosition(posXInner, posYInner).setSize(innerWidth, 10);
        this.textFieldName.setPosition(posXInner, posYInner + 11).setSize(innerWidth, 10);
        int colorBoxWidth = 32;
        int offsetBoxX = posXInner;
        int offsetBoxY = posYInner + 22;
        int offsetBoxWidth = innerWidth - colorBoxWidth - 1;
        int colorBoxX = offsetBoxX + offsetBoxWidth + 1;
        this.textOffset.setPosition(offsetBoxX, offsetBoxY).setSize(offsetBoxWidth, 10);
        this.textX.setPosition(offsetBoxX, offsetBoxY + 11).setSize(10, 10);
        this.textY.setPosition(offsetBoxX, offsetBoxY + 22).setSize(10, 10);
        this.textZ.setPosition(offsetBoxX, offsetBoxY + 33).setSize(10, 10);
        int positionTextFieldWidth = innerWidth - 11 - colorBoxWidth - 1;
        this.textFieldPosX.setPosition(posXInner + 11, posYInner + 33).setSize(positionTextFieldWidth, 10);
        this.textFieldPosY.setPosition(posXInner + 11, posYInner + 44).setSize(positionTextFieldWidth, 10);
        this.textFieldPosZ.setPosition(posXInner + 11, posYInner + 55).setSize(positionTextFieldWidth, 10);
        this.textColor.setPosition(colorBoxX, offsetBoxY).setSize(colorBoxWidth, 10);
        this.colorButton.setPosition(colorBoxX, offsetBoxY + 11).setSize(colorBoxWidth, colorBoxWidth);
        super.onResize();
    }

    @Override
    public void keyEvent(int key, char c, boolean pressed, boolean repeat, int mouseX, int mouseY) {
        if (key == Keyboard.KEY_RETURN) {
            this.ok();
        }
        super.keyEvent(key, c, pressed, repeat, mouseX, mouseY);
    }

    @Override
    public void onTextComponentChanged(GuiTextComponent textComponent) {
        this.waypoint.name = this.textFieldName.getText();
        this.waypoint.x = this.textComponentX.getValue() + this.playerOffsetX;
        this.waypoint.y = this.textComponentY.getValue() + this.playerOffsetY;
        this.waypoint.z = this.textComponentZ.getValue() + this.playerOffsetZ;
    }

    @Override
    public void onColorChanged(GuiElement source, int color) {
        this.waypoint.color = color;
    }

    public abstract void ok();

    public abstract void cancel();
}

