/*
 * Decompiled with CFR 0.152.
 */
package dev.joee.vinyl.network;

import dev.joee.vinyl.file.FileManagerClient;
import dev.joee.vinyl.file.FileManagerServer;
import dev.joee.vinyl.gui.ScreenDownloadMusic;
import dev.joee.vinyl.network.IVinylPacketHandlerLogin;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.net.handler.PacketHandlerClient;
import net.minecraft.core.net.handler.PacketHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.server.net.handler.PacketHandlerLogin;
import turniplabs.halplibe.helper.EnvironmentHelper;

public class PacketFileList
extends Packet {
    public String[] filePaths;

    public PacketFileList() {
    }

    public PacketFileList(String[] filePaths) {
        this.filePaths = filePaths;
    }

    public void read(DataInputStream dis) throws IOException {
        int length = dis.readInt();
        this.filePaths = new String[length];
        for (int i = 0; i < length; ++i) {
            this.filePaths[i] = dis.readUTF();
        }
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeInt(this.filePaths.length);
        for (String filePath : this.filePaths) {
            dos.writeUTF(filePath);
        }
    }

    public void handlePacket(PacketHandler packetHandler) {
        if (EnvironmentHelper.isServerEnvironment() && packetHandler instanceof PacketHandlerLogin) {
            ArrayList futures = new ArrayList();
            for (String filePath : this.filePaths) {
                try {
                    futures.add(FileManagerServer.instance.sendAudioFile(packetHandler, filePath));
                }
                catch (IOException e) {
                    ((PacketHandlerLogin)packetHandler).kickUser("An error occurred while downloading Vinyl music.");
                    throw new RuntimeException(e);
                }
            }
            ((CompletableFuture)CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenAccept(ignored -> ((IVinylPacketHandlerLogin)packetHandler).vinyl$markAsReceivedAudio())).exceptionally(ignored -> {
                ((PacketHandlerLogin)packetHandler).kickUser("An error occurred while downloading Vinyl music.");
                return null;
            });
        } else if (!EnvironmentHelper.isServerEnvironment() && packetHandler instanceof PacketHandlerClient) {
            String[] clientFilePaths = FileManagerClient.instance.getAudioFilePaths();
            String[] filePathsNeeded = (String[])Arrays.stream(this.filePaths).filter(f -> !Arrays.asList(clientFilePaths).contains(f)).toArray(String[]::new);
            ((PacketHandlerClient)packetHandler).addToSendQueue((Packet)new PacketFileList(filePathsNeeded));
            this.showScreen((PacketHandlerClient)packetHandler, filePathsNeeded.length);
        }
    }

    public int getEstimatedSize() {
        return Arrays.stream(this.filePaths).mapToInt(p -> p.getBytes().length).sum() + 4;
    }

    @Environment(value=EnvType.CLIENT)
    private void showScreen(PacketHandlerClient packetHandler, int totalFilesNeeded) {
        if (totalFilesNeeded == 0) {
            return;
        }
        Minecraft.getMinecraft().displayScreen((Screen)new ScreenDownloadMusic(packetHandler, totalFilesNeeded));
    }
}

