/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu.gui;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import io.github.prospector.modmenu.ModMenu;
import io.github.prospector.modmenu.config.ModMenuConfigManager;
import io.github.prospector.modmenu.gui.DescriptionListWidget;
import io.github.prospector.modmenu.gui.ModListEntry;
import io.github.prospector.modmenu.gui.ModListWidget;
import io.github.prospector.modmenu.gui.ModMenuTexturedButtonWidget;
import io.github.prospector.modmenu.gui.TextFieldWidget;
import io.github.prospector.modmenu.util.BadgeRenderer;
import io.github.prospector.modmenu.util.ButtonUtil;
import io.github.prospector.modmenu.util.HardcodedUtil;
import io.github.prospector.modmenu.util.RenderUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.Global;
import net.minecraft.core.lang.I18n;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.include.com.google.common.base.Joiner;

public class ModListScreen
extends Screen {
    private static final String FILTERS_BUTTON_LOCATION = "/assets/modmenu/textures/gui/filters_button.png";
    private static final String CONFIGURE_BUTTON_LOCATION = "/assets/modmenu/textures/gui/configure_button.png";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"modlistscreen");
    private final String textTitle;
    private TextFieldWidget searchBox;
    private DescriptionListWidget descriptionListWidget;
    private final Screen parent;
    private ModListWidget modList;
    private String tooltip;
    private ModListEntry selected;
    private BadgeRenderer badgeRenderer;
    private double scrollPercent = 0.0;
    private boolean showModCount = false;
    private boolean init = false;
    private boolean filterOptionsShown = false;
    private int paneY;
    private int paneWidth;
    private int rightPaneX;
    private int searchBoxX;
    public Set<String> showModChildren = new HashSet<String>();
    private String lastSearchString = null;
    private static final int CONFIGURE_BUTTON_ID = 0;
    private static final int WEBSITE_BUTTON_ID = 1;
    private static final int ISSUES_BUTTON_ID = 2;
    private static final int TOGGLE_FILTER_OPTIONS_BUTTON_ID = 3;
    private static final int TOGGLE_SORT_MODE_BUTTON_ID = 4;
    private static final int TOGGLE_SHOW_LIBRARIES_BUTTON_ID = 5;
    private static final int MODS_FOLDER_BUTTON_ID = 6;
    private static final int DONE_BUTTON_ID = 7;

    public ModListScreen(Screen previousGui) {
        this.parent = previousGui;
        this.textTitle = I18n.getInstance().translateKey("modmenu.title");
    }

    public void updateEvents() {
        super.updateEvents();
        int dWheel = Mouse.getEventDWheel() / 50;
        if (dWheel != 0) {
            int mouseX = Mouse.getEventX() * this.width / this.mc.resolution.getScaledHeightScreenCoords();
            int mouseY = this.height - Mouse.getEventY() * this.height / this.mc.resolution.getScaledHeightScreenCoords() - 1;
            this.mouseScrolled(mouseX, mouseY, dWheel);
        }
    }

    public void mouseScrolled(double double_1, double double_2, double double_3) {
        if (this.modList.isMouseOver(double_1, double_2)) {
            this.modList.mouseScrolled(double_1, double_2, double_3);
        }
        if (this.descriptionListWidget.isMouseOver(double_1, double_2)) {
            this.descriptionListWidget.mouseScrolled(double_1, double_2, double_3);
        }
    }

    public void tick() {
        this.searchBox.updateCursorCounter();
    }

    public void init() {
        int filtersX;
        final I18n i18n = I18n.getInstance();
        Keyboard.enableRepeatEvents((boolean)true);
        Font font = this.font;
        this.paneY = 48;
        this.paneWidth = this.width / 2 - 8;
        this.rightPaneX = this.width - this.paneWidth;
        int searchBoxWidth = this.paneWidth - 32 - 22;
        this.searchBoxX = this.paneWidth / 2 - searchBoxWidth / 2 - 11;
        String oldText = this.searchBox == null ? "" : this.searchBox.getText();
        this.searchBox = new TextFieldWidget(this.font, this.searchBoxX, 22, searchBoxWidth, 20, i18n.translateKey("modmenu.search"));
        this.searchBox.setText(oldText);
        this.modList = new ModListWidget(this.mc, this.paneWidth, this.height, this.paneY + 19, this.height - 36, 36, this.searchBox.getText(), this.modList, this);
        this.modList.setLeftPos(0);
        this.descriptionListWidget = new DescriptionListWidget(this.mc, this.paneWidth, this.height, this.paneY + 60, this.height - 36, 10, this);
        this.descriptionListWidget.setLeftPos(this.rightPaneX);
        ModMenuTexturedButtonWidget configureButton = new ModMenuTexturedButtonWidget(0, this.width - 24, this.paneY, 20, 20, 0, 0, CONFIGURE_BUTTON_LOCATION, 32, 64){

            @Override
            public void render(Minecraft mc, int mouseX, int mouseY) {
                String modid;
                this.enabled = ModListScreen.this.selected != null ? ModMenu.hasConfigScreenFactory(modid = ModListScreen.this.selected.getMetadata().getId()) || ModMenu.hasLegacyConfigScreenTask(modid) : false;
                this.visible = this.enabled;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                super.render(mc, mouseX, mouseY);
            }
        };
        int urlButtonWidths = this.paneWidth / 2 - 2;
        int cappedButtonWidth = Math.min(urlButtonWidths, 200);
        ButtonElement websiteButton = new ButtonElement(1, this.rightPaneX + urlButtonWidths / 2 - cappedButtonWidth / 2, this.paneY + 36, Math.min(urlButtonWidths, 200), 20, i18n.translateKey("modmenu.website")){

            public void drawButton(Minecraft mc, int var1, int var2) {
                this.visible = ModListScreen.this.selected != null;
                this.enabled = this.visible && ModListScreen.this.selected.getMetadata().getContact().get("homepage").isPresent();
                super.drawButton(mc, var1, var2);
            }
        };
        ButtonElement issuesButton = new ButtonElement(2, this.rightPaneX + urlButtonWidths + 4 + urlButtonWidths / 2 - cappedButtonWidth / 2, this.paneY + 36, Math.min(urlButtonWidths, 200), 20, i18n.translateKey("modmenu.issues")){

            public void drawButton(Minecraft mc, int var1, int var2) {
                this.visible = ModListScreen.this.selected != null;
                this.enabled = this.visible && ModListScreen.this.selected.getMetadata().getContact().get("issues").isPresent();
                super.drawButton(mc, var1, var2);
            }
        };
        this.buttons.add(new ModMenuTexturedButtonWidget(3, this.paneWidth / 2 + searchBoxWidth / 2 - 10 + 2, 22, 20, 20, 0, 0, FILTERS_BUTTON_LOCATION, 32, 64){

            @Override
            public void render(Minecraft mc, int int_1, int int_2) {
                super.render(mc, int_1, int_2);
                if (this.isHovered(int_1, int_2)) {
                    ModListScreen.this.setTooltip(i18n.translateKey("modmenu.toggleFilterOptions"));
                }
            }
        });
        String showLibrariesText = i18n.translateKeyAndFormat("modmenu.showLibraries", new Object[]{i18n.translateKey("modmenu.showLibraries." + ModMenuConfigManager.getConfig().showLibraries())});
        String sortingText = i18n.translateKeyAndFormat("modmenu.sorting", new Object[]{ModMenuConfigManager.getConfig().getSorting().getName()});
        int showLibrariesWidth = font.getStringWidth(showLibrariesText) + 20;
        int sortingWidth = font.getStringWidth(sortingText) + 20;
        int filtersWidth = showLibrariesWidth + sortingWidth + 2;
        if (filtersWidth + font.getStringWidth(i18n.translateKeyAndFormat("modmenu.showingMods", new Object[]{NumberFormat.getInstance().format(this.modList.getDisplayedCount()) + "/" + NumberFormat.getInstance().format(FabricLoader.getInstance().getAllMods().size())})) + 20 >= this.searchBoxX + searchBoxWidth + 22) {
            filtersX = this.paneWidth / 2 - filtersWidth / 2;
            this.showModCount = false;
        } else {
            filtersX = this.searchBoxX + searchBoxWidth + 22 - filtersWidth + 1;
            this.showModCount = true;
        }
        this.buttons.add(new ButtonElement(4, filtersX, 45, sortingWidth, 20, sortingText){

            public void drawButton(Minecraft mc, int mouseX, int mouseY) {
                this.visible = this.enabled = ModListScreen.this.filterOptionsShown;
                this.displayString = i18n.translateKeyAndFormat("modmenu.sorting", new Object[]{ModMenuConfigManager.getConfig().getSorting().getName()});
                super.drawButton(mc, mouseX, mouseY);
            }
        });
        this.buttons.add(new ButtonElement(5, filtersX + sortingWidth + 2, 45, showLibrariesWidth, 20, showLibrariesText){

            public void drawButton(Minecraft mc, int mouseX, int mouseY) {
                this.visible = this.enabled = ModListScreen.this.filterOptionsShown;
                this.displayString = i18n.translateKeyAndFormat("modmenu.showLibraries", new Object[]{i18n.translateKey("modmenu.showLibraries." + ModMenuConfigManager.getConfig().showLibraries())});
                super.drawButton(mc, mouseX, mouseY);
            }
        });
        this.buttons.add(configureButton);
        this.buttons.add(websiteButton);
        this.buttons.add(issuesButton);
        this.buttons.add(ButtonUtil.createButton(6, this.width / 2 - 154, this.height - 28, 150, 20, "Open Mods Folder"));
        this.buttons.add(ButtonUtil.createButton(7, this.width / 2 + 4, this.height - 28, 150, 20, "Done"));
        this.searchBox.setFocused(true);
        this.init = true;
    }

    protected void buttonClicked(ButtonElement button) {
        switch (button.id) {
            case 0: {
                String modid = Objects.requireNonNull(this.selected).getMetadata().getId();
                Screen screen = ModMenu.getConfigScreen(modid, this);
                if (screen != null) {
                    this.mc.displayScreen(screen);
                    break;
                }
                ModMenu.openConfigScreen(modid);
                break;
            }
            case 1: {
                ModMetadata metadata = Objects.requireNonNull(this.selected).getMetadata();
                metadata.getContact().get("homepage").ifPresent(Sys::openURL);
                break;
            }
            case 2: {
                ModMetadata metadata = Objects.requireNonNull(this.selected).getMetadata();
                metadata.getContact().get("issues").ifPresent(Sys::openURL);
                break;
            }
            case 3: {
                this.filterOptionsShown = !this.filterOptionsShown;
                break;
            }
            case 4: {
                ModMenuConfigManager.getConfig().toggleSortMode();
                this.modList.reloadFilters();
                break;
            }
            case 5: {
                ModMenuConfigManager.getConfig().toggleShowLibraries();
                this.modList.reloadFilters();
                break;
            }
            case 6: {
                File modsFolder = new File(FabricLoader.getInstance().getGameDir().toFile(), "mods");
                try {
                    Sys.openURL((String)modsFolder.toURI().toURL().toString());
                }
                catch (MalformedURLException e) {
                    LOGGER.error("Malformed mods folder URL", (Throwable)e);
                }
                break;
            }
            case 7: {
                this.mc.displayScreen(this.parent);
            }
        }
    }

    public ModListWidget getModList() {
        return this.modList;
    }

    public void keyPressed(char char_1, int int_1, int mouseX, int mouseY) {
        this.searchBox.textboxKeyTyped(char_1, int_1);
        if (int_1 == 1) {
            this.mc.displayScreen(this.parent);
        }
        this.modList.keyPressed(int_1, 0, 0);
        this.descriptionListWidget.keyPressed(int_1, 0, 0);
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        this.modList.mouseClicked(mouseX, mouseY, mouseButton);
        this.descriptionListWidget.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void mouseReleased(int mouseX, int mouseY, int mouseButton) {
        super.mouseReleased(mouseX, mouseY, mouseButton);
        if (mouseButton != -1) {
            this.modList.mouseReleased(mouseX, mouseY, mouseButton);
            this.descriptionListWidget.mouseReleased(mouseX, mouseY, mouseButton);
        }
    }

    public void render(int mouseX, int mouseY, float delta) {
        I18n i18n = I18n.getInstance();
        int mouseDX = Mouse.getEventDX() * this.width / this.mc.resolution.getScaledWidthScreenCoords();
        int mouseDY = this.height - Mouse.getEventDY() * this.height / this.mc.resolution.getScaledHeightScreenCoords() - 1;
        for (int button = 0; button < Mouse.getButtonCount(); ++button) {
            if (!Mouse.isButtonDown((int)button)) continue;
            this.modList.mouseDragged(mouseX, mouseY, button, mouseDX, mouseDY);
            this.descriptionListWidget.mouseDragged(mouseX, mouseY, button, mouseDX, mouseDY);
        }
        Font font = this.font;
        if (!this.searchBox.getText().equals(this.lastSearchString)) {
            this.lastSearchString = this.searchBox.getText();
            this.modList.filter(this.lastSearchString, false);
        }
        this.overlayBackground(this.paneWidth, 0, this.rightPaneX, this.height, 64, 64, 64, 255, 255);
        this.tooltip = null;
        ModListEntry selectedEntry = this.selected;
        if (selectedEntry != null) {
            this.descriptionListWidget.render(mouseX, mouseY, delta);
        }
        this.modList.render(mouseX, mouseY, delta);
        this.searchBox.drawTextBox();
        GL11.glDisable((int)3042);
        this.drawStringCentered(font, this.textTitle, this.modList.getWidth() / 2, 8, 0xFFFFFF);
        super.render(mouseX, mouseY, delta);
        if (this.showModCount || !this.filterOptionsShown) {
            String showModCountString = i18n.translateKeyAndFormat("modmenu.showingMods", new Object[]{NumberFormat.getInstance().format(this.modList.getDisplayedCount()) + "/" + NumberFormat.getInstance().format(FabricLoader.getInstance().getAllMods().size())});
            font.drawString(showModCountString, this.searchBoxX, 52, 0xFFFFFF);
        }
        if (selectedEntry != null) {
            ModMetadata metadata = selectedEntry.getMetadata();
            int x = this.rightPaneX;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.selected.bindIconTexture();
            ModListEntry.internalRender(this.paneY, x);
            int lineSpacing = 10;
            int imageOffset = 36;
            String name = metadata.getName();
            if (name.equals("Minecraft")) {
                name = "Better than Adventure";
            }
            String trimmedName = name = HardcodedUtil.formatFabricModuleName(name);
            int maxNameWidth = this.width - (x + imageOffset);
            trimmedName = ModListScreen.getString(font, name, trimmedName, maxNameWidth);
            font.drawString(trimmedName, x + imageOffset, this.paneY + 1, 0xFFFFFF);
            if (mouseX > x + imageOffset && mouseY > this.paneY + 1 && mouseY < this.paneY + 1 + 9 && mouseX < x + imageOffset + font.getStringWidth(trimmedName)) {
                this.setTooltip(i18n.translateKeyAndFormat("modmenu.modIdToolTip", new Object[]{metadata.getId()}));
            }
            if (this.init || this.badgeRenderer == null || this.badgeRenderer.getMetadata() != metadata) {
                this.badgeRenderer = new BadgeRenderer(this.mc, x + imageOffset + font.getStringWidth(trimmedName) + 2, this.paneY, this.width - 28, selectedEntry.container, this);
                this.init = false;
            }
            this.badgeRenderer.draw(mouseX, mouseY);
            String versionString = metadata.getName().equals("Minecraft") ? Global.VERSION : metadata.getVersion().getFriendlyString();
            font.drawString("v" + versionString, x + imageOffset, this.paneY + 2 + lineSpacing, 0x808080);
            ArrayList names = new ArrayList();
            metadata.getAuthors().stream().filter(Objects::nonNull).map(Person::getName).filter(Objects::nonNull).forEach(names::add);
            if (!names.isEmpty()) {
                String authors = names.size() > 1 ? Joiner.on((String)", ").join(names) : (String)names.get(0);
                RenderUtils.INSTANCE.drawWrappedString(font, i18n.translateKeyAndFormat("modmenu.authorPrefix", new Object[]{authors}), x + imageOffset, this.paneY + 2 + lineSpacing * 2, this.paneWidth - imageOffset - 4, 1, 0x808080);
            }
            if (this.tooltip != null) {
                this.renderTooltip(Lists.newArrayList((Iterable)Splitter.on((String)"\n").split((CharSequence)this.tooltip)), mouseX, mouseY);
            }
        }
    }

    static String getString(Font font, String name, String trimmedName, int maxNameWidth) {
        if (font.getStringWidth(name) > maxNameWidth) {
            int maxWidth = maxNameWidth - font.getStringWidth("...");
            trimmedName = "";
            while (font.getStringWidth(trimmedName) < maxWidth && trimmedName.length() < name.length()) {
                trimmedName = trimmedName + name.charAt(trimmedName.length());
            }
            trimmedName = trimmedName.isEmpty() ? "..." : trimmedName.substring(0, trimmedName.length() - 1) + "...";
        }
        return trimmedName;
    }

    public void overlayBackground(int x1, int y1, int x2, int y2, int red, int green, int blue, int startAlpha, int endAlpha) {
        Tessellator tessellator = Tessellator.instance;
        this.mc.textureManager.bindTexture(this.mc.textureManager.loadTexture("/gui/background.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA(red, green, blue, endAlpha);
        tessellator.addVertexWithUV((double)x1, (double)y2, 0.0, (double)((float)x1 / 32.0f), (double)((float)y2 / 32.0f));
        tessellator.addVertexWithUV((double)x2, (double)y2, 0.0, (double)((float)x2 / 32.0f), (double)((float)y2 / 32.0f));
        tessellator.setColorRGBA(red, green, blue, startAlpha);
        tessellator.addVertexWithUV((double)x2, (double)y1, 0.0, (double)((float)x2 / 32.0f), (double)((float)y1 / 32.0f));
        tessellator.addVertexWithUV((double)x1, (double)y1, 0.0, (double)((float)x1 / 32.0f), (double)((float)y1 / 32.0f));
        tessellator.draw();
    }

    public void removed() {
        super.removed();
        this.modList.close();
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public ModListEntry getSelectedEntry() {
        return this.selected;
    }

    public void updateSelectedEntry(ModListEntry entry) {
        if (entry != null) {
            this.selected = entry;
        }
    }

    public double getScrollPercent() {
        return this.scrollPercent;
    }

    public void updateScrollPercent(double scrollPercent) {
        this.scrollPercent = scrollPercent;
    }

    public String getSearchInput() {
        return this.searchBox.getText();
    }

    public boolean showingFilterOptions() {
        return this.filterOptionsShown;
    }

    public void renderTooltip(List<String> list, int i, int j) {
        if (!list.isEmpty()) {
            Font font = this.font;
            GL11.glDisable((int)32826);
            GL11.glDisable((int)2929);
            int k = 0;
            for (String string : list) {
                int l = font.getStringWidth(string);
                if (l <= k) continue;
                k = l;
            }
            int m = i + 12;
            int n = j - 12;
            int p = 8;
            if (list.size() > 1) {
                p += 2 + (list.size() - 1) * 10;
            }
            if (m + k > this.width) {
                m -= 28 + k;
            }
            if (n + p + 6 > this.height) {
                n = this.height - p - 6;
            }
            int transparentGrey = -1073741824;
            int margin = 3;
            this.fillGradient(m - margin, n - margin, m + k + margin, n + p + margin, transparentGrey, transparentGrey);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)300.0f);
            for (int t = 0; t < list.size(); ++t) {
                String string2 = list.get(t);
                if (string2 != null) {
                    font.drawString(string2, m, n, 0xFFFFFF);
                }
                if (t == 0) {
                    n += 2;
                }
                n += 10;
            }
            GL11.glPopMatrix();
            GL11.glEnable((int)2929);
            GL11.glEnable((int)32826);
        }
    }

    protected void fillGradient(int i, int j, int k, int l, int m, int n) {
        float f = (float)(m >> 24 & 0xFF) / 255.0f;
        float g = (float)(m >> 16 & 0xFF) / 255.0f;
        float h = (float)(m >> 8 & 0xFF) / 255.0f;
        float o = (float)(m & 0xFF) / 255.0f;
        float p = (float)(n >> 24 & 0xFF) / 255.0f;
        float q = (float)(n >> 16 & 0xFF) / 255.0f;
        float r = (float)(n >> 8 & 0xFF) / 255.0f;
        float s = (float)(n & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_F(g, h, o, f);
        tessellator.addVertex((double)k, (double)j, 300.0);
        tessellator.addVertex((double)i, (double)j, 300.0);
        tessellator.setColorRGBA_F(q, r, s, p);
        tessellator.addVertex((double)i, (double)l, 300.0);
        tessellator.addVertex((double)k, (double)l, 300.0);
        tessellator.draw();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }
}

