/*
 * Decompiled with CFR 0.152.
 */
package bigsir.untitledshadermod.utils;

public class Bayer {
    private Bayer() {
    }

    public static float[] gen1DBayerF(int level) {
        double[] maxValue = new double[1];
        double[][] bayer = Bayer.genBayer(level, maxValue);
        float[] bayerF = new float[bayer.length * bayer.length];
        maxValue[0] = maxValue[0] * 0.5;
        for (int i = 0; i < bayer.length; ++i) {
            for (int j = 0; j < bayer.length; ++j) {
                bayerF[j * bayer.length + i] = (float)bayer[j][i] - (float)maxValue[0];
            }
        }
        return bayerF;
    }

    public static float[][] genBayerF(int level, double[] max) {
        double[][] bayer = Bayer.genBayer(level, max);
        float[][] bayerF = new float[bayer.length][bayer.length];
        for (int i = 0; i < bayer.length; ++i) {
            for (int j = 0; j < bayer.length; ++j) {
                bayerF[i][j] = (float)bayer[i][j];
            }
        }
        return bayerF;
    }

    public static double[][] genBayer(int level, double[] max) {
        return Bayer.genBayer(level, Math.max(level, 0), max);
    }

    private static double[][] genBayer(int topLevel, int level, double[] max) {
        double[][] bayer0 = new double[][]{{0.0, 2.0}, {3.0, 1.0}};
        if (level == 0) {
            if (topLevel == level) {
                for (int i = 0; i < 4; ++i) {
                    double[] dArray = bayer0[i % 2];
                    int n = i / 2;
                    dArray[n] = dArray[n] / 4.0;
                }
            }
            return bayer0;
        }
        int dim = (int)Math.pow(2.0, (double)level + 1.0);
        int mod = (int)Math.pow(2.0, level);
        double[][] bayerN = new double[dim][dim];
        double[][] prevBayer = Bayer.genBayer(topLevel, level - 1, max);
        for (int i = 0; i < dim; ++i) {
            for (int j = 0; j < dim; ++j) {
                bayerN[i][j] = 4.0 * prevBayer[i % mod][j % mod] + bayer0[i / mod][j / mod];
                if (level != topLevel) continue;
                double[] dArray = bayerN[i];
                int n = j;
                dArray[n] = dArray[n] / (double)(dim * dim);
                max[0] = Math.max(max[0], bayerN[i][j]);
            }
        }
        return bayerN;
    }
}

