/*
 * Decompiled with CFR 0.152.
 */
package bigsir.untitledshadermod;

import bigsir.untitledshadermod.utils.Bayer;
import bigsir.untitledshadermod.utils.ShaderInject;
import bigsir.untitledshadermod.utils.ShaderParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.api.ModInitializer;
import net.minecraft.client.gui.options.components.BooleanOptionComponent;
import net.minecraft.client.gui.options.components.OptionsCategory;
import net.minecraft.client.gui.options.components.OptionsComponent;
import net.minecraft.client.gui.options.components.ToggleableOptionComponent;
import net.minecraft.client.gui.options.data.OptionsPage;
import net.minecraft.client.gui.options.data.OptionsPages;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.OptionBoolean;
import net.minecraft.client.option.OptionRange;
import net.minecraft.client.option.OptionToggleable;
import net.minecraft.core.item.Items;
import net.minecraft.core.lang.I18n;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import turniplabs.halplibe.util.ClientStartEntrypoint;
import turniplabs.halplibe.util.OptionsInitEntrypoint;

public class UShaderMod
implements ModInitializer,
ClientStartEntrypoint,
OptionsInitEntrypoint {
    public static final String MOD_ID = "untitledshadermod";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"untitledshadermod");
    public static OptionBoolean toneMapping;
    public static OptionBoolean dithering;
    public static OptionRange redBits;
    public static OptionRange greenBits;
    public static OptionRange blueBits;
    public static OptionRange bayerMatrix;
    public static OptionRange bayerBrightness;
    public static OptionRange toneMapFalloff;
    public static OptionRange toneMapFalloffStart;
    public static OptionRange toneMapFalloffEnd;
    public static OptionRange ditherFalloff;
    public static OptionRange ditherFalloffStart;
    public static OptionRange ditherFalloffEnd;
    public static OptionRange falloffType;
    public static OptionRange pixelSize;
    public static OptionBoolean adaptiveBrightness;
    public static int bayerSizeCache;
    public static float bayerBrightnessCache;
    public static float bayerMaxCache;
    public static float[] stepCache;
    public static int texMatrix;
    public static float bayerTexMiddle;
    public static float bayerTexOffset;
    public static final String[] FALLOFF_STRING;
    public static final String[] FALLOFF_TYPE_STRING;
    public static final String ERROR_KEY = "key.error";
    private static final String KEY_PREFIX = "untitledshadermod.key.";

    public void onInitialize() {
        LOGGER.info("Untitled Shader Mod initialized.");
    }

    @NotNull
    private static String key(@NotNull String string) {
        return "untitledshadermod." + string;
    }

    @NotNull
    public static String translateKey(@NotNull String string) {
        return I18n.getInstance().translateKey(KEY_PREFIX + string);
    }

    public static void setupToneMap() {
        float nRed = (float)Math.pow(2.0, ((Integer)UShaderMod.redBits.value).intValue());
        float nGreen = (float)Math.pow(2.0, ((Integer)UShaderMod.greenBits.value).intValue());
        float nBlue = (float)Math.pow(2.0, ((Integer)UShaderMod.blueBits.value).intValue());
        UShaderMod.stepCache[0] = nRed <= 1.0f ? 0.0f : 1.0f / (nRed - 1.0f);
        UShaderMod.stepCache[1] = nGreen <= 1.0f ? 0.0f : 1.0f / (nGreen - 1.0f);
        UShaderMod.stepCache[2] = nBlue <= 1.0f ? 0.0f : 1.0f / (nBlue - 1.0f);
    }

    public static void setupBayer() {
        float[] bayerArray = Bayer.gen1DBayerF((Integer)UShaderMod.bayerMatrix.value);
        bayerMaxCache = 0.0f;
        bayerSizeCache = (int)Math.pow(2.0, (Integer)UShaderMod.bayerMatrix.value + 1);
        bayerTexOffset = 1.0f / (float)(bayerSizeCache * bayerSizeCache);
        bayerTexMiddle = bayerTexOffset / 2.0f;
        if (texMatrix != -1) {
            GL11.glDeleteTextures((int)texMatrix);
        }
        texMatrix = GL11.glGenTextures();
        GL11.glBindTexture((int)3552, (int)texMatrix);
        GL11.glTexParameteri((int)3552, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3552, (int)10243, (int)10497);
        GL11.glTexParameteri((int)3552, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3552, (int)10240, (int)9728);
        GL11.glTexImage1D((int)3552, (int)0, (int)34837, (int)bayerArray.length, (int)0, (int)6403, (int)5126, (float[])bayerArray);
        GL11.glBindTexture((int)3552, (int)0);
    }

    public void initOptions(GameSettings settings) {
        toneMapping = new OptionBoolean(settings, UShaderMod.key("option.tone_mapping"), true);
        redBits = new OptionRange(settings, UShaderMod.key("option.red_bits"), 3, 9);
        greenBits = new OptionRange(settings, UShaderMod.key("option.green_bits"), 2, 9);
        blueBits = new OptionRange(settings, UShaderMod.key("option.blue_bits"), 3, 9);
        toneMapFalloff = new OptionRange(settings, UShaderMod.key("option.tone_map.falloff"), 0, 3);
        toneMapFalloffStart = new OptionRange(settings, UShaderMod.key("option.tone_map.falloff_start"), 0, 512);
        toneMapFalloffEnd = new OptionRange(settings, UShaderMod.key("option.tone_map.falloff_end"), 32, 512);
        dithering = new OptionBoolean(settings, UShaderMod.key("option.dithering"), true);
        bayerMatrix = new OptionRange(settings, UShaderMod.key("option.bayer_matrix"), 3, 4);
        bayerBrightness = new OptionRange(settings, UShaderMod.key("option.bayer_brightness"), 100, 201);
        adaptiveBrightness = new OptionBoolean(settings, UShaderMod.key("option.adaptive_brightness"), true);
        ditherFalloff = new OptionRange(settings, UShaderMod.key("option.dither.falloff"), 0, 3);
        ditherFalloffStart = new OptionRange(settings, UShaderMod.key("option.dither.falloff_start"), 0, 512);
        ditherFalloffEnd = new OptionRange(settings, UShaderMod.key("option.dither.falloff_end"), 32, 512);
        falloffType = new OptionRange(settings, UShaderMod.key("option.falloff_type"), 0, 2);
        pixelSize = new OptionRange(settings, UShaderMod.key("option.pixel_size"), 0, 4);
    }

    public void afterClientStart() {
        OptionsPages.register((OptionsPage)new OptionsPage(UShaderMod.key("options"), Items.PAINTBRUSH.getDefaultStack())).withComponent((OptionsComponent)new OptionsCategory(UShaderMod.key("options.category.common")).withComponent((OptionsComponent)new ToggleableOptionComponent((OptionToggleable)falloffType))).withComponent((OptionsComponent)new OptionsCategory(UShaderMod.key("options.category.tone_map")).withComponent((OptionsComponent)new BooleanOptionComponent(toneMapping)).withComponent((OptionsComponent)new ToggleableOptionComponent((OptionToggleable)redBits)).withComponent((OptionsComponent)new ToggleableOptionComponent((OptionToggleable)greenBits)).withComponent((OptionsComponent)new ToggleableOptionComponent((OptionToggleable)blueBits)).withComponent((OptionsComponent)new ToggleableOptionComponent((OptionToggleable)toneMapFalloff)).withComponent((OptionsComponent)new ToggleableOptionComponent((OptionToggleable)toneMapFalloffStart)).withComponent((OptionsComponent)new ToggleableOptionComponent((OptionToggleable)toneMapFalloffEnd))).withComponent((OptionsComponent)new OptionsCategory(UShaderMod.key("options.category.dither")).withComponent((OptionsComponent)new BooleanOptionComponent(dithering)).withComponent((OptionsComponent)new ToggleableOptionComponent((OptionToggleable)bayerMatrix)).withComponent((OptionsComponent)new ToggleableOptionComponent((OptionToggleable)bayerBrightness)).withComponent((OptionsComponent)new BooleanOptionComponent(adaptiveBrightness)).withComponent((OptionsComponent)new ToggleableOptionComponent((OptionToggleable)pixelSize)).withComponent((OptionsComponent)new ToggleableOptionComponent((OptionToggleable)ditherFalloff)).withComponent((OptionsComponent)new ToggleableOptionComponent((OptionToggleable)ditherFalloffStart)).withComponent((OptionsComponent)new ToggleableOptionComponent((OptionToggleable)ditherFalloffEnd)));
        UShaderMod.setupBayer();
        UShaderMod.setupToneMap();
        bayerBrightnessCache = (float)((Integer)UShaderMod.bayerBrightness.value).intValue() / 100.0f;
    }

    @NotNull
    public static List<String> readLinesResource(@NotNull String path) {
        List<String> list;
        block13: {
            list = new ArrayList<String>();
            try (InputStream inStream = UShaderMod.class.getResourceAsStream(path);){
                if (inStream == null) break block13;
                try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(inStream));){
                    list = bufReader.lines().collect(Collectors.toList());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return list;
    }

    public void beforeClientStart() {
        List<String> list = UShaderMod.readLinesResource(String.format("/assets/%s/shaders/tonemap_inject_new.glsl", MOD_ID));
        String src = String.join((CharSequence)"\n", list);
        ShaderParser parser = new ShaderParser();
        parser.findFunctions(src);
        ShaderInject.register("fragment/post", (n, s) -> UShaderMod.injectPostMod(n, s, parser));
    }

    @NotNull
    public static String injectPostMod(@NotNull String shaderName, @NotNull String fSource, @NotNull ShaderParser parser) {
        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(fSource.split("\n")));
        ArrayList<String> globals = new ArrayList<String>(parser.globals);
        ShaderParser sourceParser = new ShaderParser();
        sourceParser.findFunctions(fSource);
        for (int i = globals.size() - 1; i >= 0; --i) {
            for (String global : sourceParser.globals) {
                if (!StringUtils.strip((String)global).equals(StringUtils.strip((String)((String)globals.get(i))))) continue;
                globals.remove(i);
            }
        }
        int targetLine = -1;
        int mainLine = -1;
        int versionLine = -1;
        for (int i = 0; i < lines.size(); ++i) {
            if (((String)lines.get(i)).contains("gl_FragColor")) {
                targetLine = i;
            }
            if (((String)lines.get(i)).contains("void main")) {
                mainLine = i;
            }
            if (!((String)lines.get(i)).contains("#version")) continue;
            versionLine = i;
        }
        if (versionLine != -1) {
            for (String global : globals) {
                lines.add(versionLine + 1, global);
            }
        }
        String main = null;
        if (mainLine != -1) {
            for (String func : parser.functions) {
                if (func.contains("void main")) {
                    main = func;
                    continue;
                }
                lines.add(mainLine + globals.size(), func);
            }
        }
        if (targetLine != -1 && main != null) {
            lines.add(targetLine + globals.size() + parser.functions.size(), ShaderParser.extractFunctionBody(main));
        }
        return String.join((CharSequence)"\n", lines);
    }

    @NotNull
    public static String translateFrom(@NotNull String[] keyArray, int index) {
        if (index < 0 || index >= keyArray.length) {
            return I18n.getInstance().translateKey(UShaderMod.key(ERROR_KEY));
        }
        return I18n.getInstance().translateKey(keyArray[index]);
    }

    static {
        stepCache = new float[3];
        texMatrix = -1;
        bayerTexMiddle = 0.0f;
        bayerTexOffset = 0.0f;
        FALLOFF_STRING = new String[]{"options.off", UShaderMod.key("key.normal"), UShaderMod.key("key.inverted")};
        FALLOFF_TYPE_STRING = new String[]{UShaderMod.key("key.spherical"), UShaderMod.key("key.linear")};
    }
}

