/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu.util;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.ContactInformation;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModDependency;
import net.fabricmc.loader.api.metadata.ModEnvironment;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.ModOrigin;
import net.fabricmc.loader.api.metadata.Person;

public class TestModContainer
implements ModContainer {
    public static final Random RAND = new Random();
    private static Collection<ModContainer> testModContainers;
    private final ModMetadata metadata = new TestModMetadata();
    private final Path rootPath = (Path)((ModContainer)FabricLoader.getInstance().getModContainer("fabricloader").orElseThrow(IllegalStateException::new)).getRootPaths().get(0);

    public static Collection<ModContainer> getTestModContainers() {
        if (testModContainers == null) {
            testModContainers = new ArrayList<ModContainer>();
            for (int i = 0; i < 1000; ++i) {
                testModContainers.add(new TestModContainer());
            }
        }
        return testModContainers;
    }

    public ModMetadata getMetadata() {
        return this.metadata;
    }

    public List<Path> getRootPaths() {
        return Collections.emptyList();
    }

    public ModOrigin getOrigin() {
        return null;
    }

    public Optional<ModContainer> getContainingMod() {
        return Optional.empty();
    }

    public Collection<ModContainer> getContainedMods() {
        return Collections.emptyList();
    }

    public Path getRootPath() {
        return this.rootPath;
    }

    public Path getPath(String file) {
        return null;
    }

    public static class TestModMetadata
    implements ModMetadata {
        private final String id = TestModMetadata.randomAlphabetic(10, 50).toLowerCase(Locale.ROOT);
        private final String description = TestModMetadata.randomAlphabetic(0, 500);
        private final Version version;

        public TestModMetadata() {
            try {
                this.version = SemanticVersion.parse((String)String.format("%d.%d.%d+%s", RAND.nextInt(10), RAND.nextInt(50), RAND.nextInt(200), TestModMetadata.randomAlphanumeric(2, 10)));
            }
            catch (VersionParsingException e) {
                throw new AssertionError("Generated version is not semantic", e);
            }
        }

        private static String randomAlphabetic(int minLen, int maxLen) {
            int len = ThreadLocalRandom.current().nextInt(maxLen - minLen + 1) + minLen;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                int rand = ThreadLocalRandom.current().nextInt(52);
                if (rand < 26) {
                    sb.append((char)(65 + rand));
                    continue;
                }
                sb.append((char)(71 + rand));
            }
            return sb.toString();
        }

        private static String randomAlphanumeric(int minLen, int maxLen) {
            int len = ThreadLocalRandom.current().nextInt(maxLen - minLen + 1) + minLen;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                int rand = ThreadLocalRandom.current().nextInt(62);
                if (rand < 26) {
                    sb.append((char)(65 + rand));
                    continue;
                }
                if (rand < 52) {
                    sb.append((char)(71 + rand));
                    continue;
                }
                sb.append((char)(-4 + rand));
            }
            return sb.toString();
        }

        public String getType() {
            return "test";
        }

        public String getId() {
            return this.id;
        }

        public Collection<String> getProvides() {
            return Collections.emptyList();
        }

        public Version getVersion() {
            return this.version;
        }

        public ModEnvironment getEnvironment() {
            return null;
        }

        public Collection<ModDependency> getDependencies() {
            return Collections.emptyList();
        }

        public String getName() {
            return this.getId();
        }

        public String getDescription() {
            return this.description;
        }

        public Collection<Person> getAuthors() {
            return Collections.emptyList();
        }

        public Collection<Person> getContributors() {
            return Collections.emptyList();
        }

        public ContactInformation getContact() {
            return ContactInformation.EMPTY;
        }

        public Collection<String> getLicense() {
            return Collections.emptyList();
        }

        public Optional<String> getIconPath(int size) {
            return Optional.empty();
        }

        public boolean containsCustomValue(String key) {
            return false;
        }

        public CustomValue getCustomValue(String key) {
            return null;
        }

        public Map<String, CustomValue> getCustomValues() {
            return new HashMap<String, CustomValue>();
        }

        public boolean containsCustomElement(String key) {
            return false;
        }
    }
}

