/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu.mixin;

import io.github.prospector.modmenu.ModMenu;
import io.github.prospector.modmenu.mixin.LanguageAccessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.lang.Language;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={I18n.class}, remap=false)
public abstract class MixinI18n {
    @Shadow
    private Language currentLanguage;

    @Shadow
    public static InputStream getResourceAsStream(String path) {
        throw new AssertionError();
    }

    @Inject(method={"reload(Ljava/lang/String;Z)V"}, at={@At(value="TAIL")})
    private void modmenu$addLangEntries(String languageCode, boolean save, CallbackInfo ci) {
        Properties entries = ((LanguageAccessor)this.currentLanguage).getEntries();
        String lang = "/lang/modmenu/" + this.currentLanguage.getId() + ".lang";
        try (InputStream stream = MixinI18n.getResourceAsStream(lang);){
            if (stream != null) {
                InputStreamReader r = new InputStreamReader(stream, StandardCharsets.UTF_8);
                entries.load(r);
            }
        }
        catch (IOException e) {
            ModMenu.LOGGER.error("Something went wrong!", (Throwable)e);
        }
        String defaultLang = "/lang/modmenu/en_US.lang";
        try (InputStream stream = MixinI18n.getResourceAsStream(defaultLang);){
            if (stream != null) {
                InputStreamReader r = new InputStreamReader(stream, StandardCharsets.UTF_8);
                ((LanguageAccessor)Language.Default.INSTANCE).getEntries().load(r);
            }
        }
        catch (IOException e) {
            ModMenu.LOGGER.error("Something went wrong!", (Throwable)e);
        }
    }
}

