/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.tessellator.Tessellator;
import org.lwjgl.opengl.GL11;

public class ModMenuTexturedButtonWidget
extends ButtonElement {
    private final String texture;
    private final int u;
    private final int v;
    private final int uWidth;
    private final int vHeight;

    protected ModMenuTexturedButtonWidget(int id, int xPosition, int yPosition, int width, int height, int u, int v, String texture) {
        this(id, xPosition, yPosition, width, height, u, v, texture, 256, 256);
    }

    protected ModMenuTexturedButtonWidget(int id, int xPosition, int yPosition, int width, int height, int u, int v, String texture, int uWidth, int vHeight) {
        this(id, xPosition, yPosition, width, height, u, v, texture, uWidth, vHeight, "");
    }

    protected ModMenuTexturedButtonWidget(int id, int xPosition, int yPosition, int width, int height, int u, int v, String texture, int uWidth, int vHeight, String message) {
        super(id, xPosition, yPosition, width, height, message);
        this.uWidth = uWidth;
        this.vHeight = vHeight;
        this.u = u;
        this.v = v;
        this.texture = texture;
    }

    protected void setPos(int x, int y) {
        this.xPosition = x;
        this.yPosition = y;
    }

    public boolean isHovered(int mouseX, int mouseY) {
        return mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
    }

    public void drawButton(Minecraft minecraft, int mouseX, int mouseY) {
        this.render(minecraft, mouseX, mouseY);
    }

    public void render(Minecraft mc, int mouseX, int mouseY) {
        if (this.visible) {
            Font font = mc.font;
            mc.textureManager.bindTexture(mc.textureManager.loadTexture(this.texture));
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            boolean hovered = this.isHovered(mouseX, mouseY);
            int adjustedV = this.v;
            if (!this.enabled) {
                adjustedV += this.height * 2;
            } else if (hovered) {
                adjustedV += this.height;
            }
            float uScale = 1.0f / (float)this.uWidth;
            float vScale = 1.0f / (float)this.vHeight;
            Tessellator tess = Tessellator.instance;
            tess.startDrawingQuads();
            tess.addVertexWithUV((double)this.xPosition, (double)this.yPosition + (double)this.height, (double)this.zLevel, (double)((float)this.u * uScale), (double)((float)(adjustedV + this.height) * vScale));
            tess.addVertexWithUV((double)this.xPosition + (double)this.width, (double)this.yPosition + (double)this.height, (double)this.zLevel, (double)((float)(this.u + this.width) * uScale), (double)((float)(adjustedV + this.height) * vScale));
            tess.addVertexWithUV((double)this.xPosition + (double)this.width, (double)this.yPosition, (double)this.zLevel, (double)((float)(this.u + this.width) * uScale), (double)((float)adjustedV * vScale));
            tess.addVertexWithUV((double)this.xPosition, (double)this.yPosition, (double)this.zLevel, (double)((float)this.u * uScale), (double)((float)adjustedV * vScale));
            tess.draw();
            this.mouseDragged(mc, mouseX, mouseY);
            if (!this.enabled) {
                this.drawStringCentered(font, this.displayString, this.xPosition + this.width / 2, this.yPosition + (this.height - 8) / 2, -6250336);
            } else if (hovered) {
                this.drawStringCentered(font, this.displayString, this.xPosition + this.width / 2, this.yPosition + (this.height - 8) / 2, 0xFFFFA0);
            } else {
                this.drawStringCentered(font, this.displayString, this.xPosition + this.width / 2, this.yPosition + (this.height - 8) / 2, 0xE0E0E0);
            }
        }
    }
}

