/*
 * Decompiled with CFR 0.152.
 */
package b100.minimap.gui;

import b100.minimap.gui.GuiElement;

public class GuiTextElement
extends GuiElement {
    public String text;
    public Align alignHorizontal = Align.CENTER;
    public Align alignVertical = Align.CENTER;
    public int textColor = 0xFFFFFF;

    public GuiTextElement(String text) {
        this.setText(text);
    }

    public GuiTextElement(String text, Align align) {
        this.setText(text);
        this.alignHorizontal = align;
        this.alignVertical = align;
    }

    public GuiTextElement(String text, Align alignHorizontal, Align alignVertical) {
        this.setText(text);
        this.alignHorizontal = alignHorizontal;
        this.alignVertical = alignVertical;
    }

    @Override
    public void draw(float partialTicks) {
        int stringWidth = this.utils.getStringWidth(this.text);
        int stringHeight = 8;
        int x = (int)((float)this.posX + this.alignHorizontal.val * (float)(this.width - stringWidth));
        int y = (int)((float)this.posY + this.alignVertical.val * (float)(this.height - stringHeight));
        this.utils.drawString(this.text, x, y, this.getTextColor());
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setAlignHorizontal(Align align) {
        this.alignHorizontal = align;
    }

    public void setAlignVertical(Align align) {
        this.alignVertical = align;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public static enum Align {
        START(0.0f),
        CENTER(0.5f),
        END(1.0f);

        private float val;

        private Align(float val) {
            this.val = val;
        }
    }
}

