/*
 * Decompiled with CFR 0.152.
 */
package b100.minimap.gui;

import b100.minimap.gui.CancelEventException;
import b100.minimap.gui.GuiContainer;
import b100.minimap.gui.GuiContainerBox;
import b100.minimap.gui.GuiElement;
import b100.minimap.gui.GuiScreen;

public class GuiContextMenu
extends GuiContainer {
    public GuiScreen screen;
    public GuiContainerBox contextMenuContainer = new GuiContainerBox();

    public GuiContextMenu(GuiScreen screen) {
        this.screen = screen;
        this.setPosition(0, 0);
        this.setSize(screen.width, screen.height);
        this.add(this.contextMenuContainer);
    }

    @Override
    public void onAddToContainer(GuiContainer container) {
        int paddingOuter = 2;
        boolean paddingInner = true;
        int elementWidth = 0;
        int elementHeight = 0;
        int elementCount = this.contextMenuContainer.elements.size();
        for (int i = 0; i < elementCount; ++i) {
            GuiElement element = (GuiElement)this.contextMenuContainer.elements.get(i);
            elementWidth = Math.max(elementWidth, element.width);
            elementHeight = Math.max(elementHeight, element.height);
        }
        int width = 4 + elementWidth;
        int height = 4 + elementCount * elementHeight + (elementCount - 1) * 1;
        int x = 0;
        int y = 0;
        if (this.screen.cursorX + width < this.screen.width) {
            x = this.screen.cursorX;
        } else if (this.screen.cursorX - width > 0) {
            x = this.screen.cursorX;
        }
        if (this.screen.cursorY + height < this.screen.height) {
            y = this.screen.cursorY;
        } else if (this.screen.cursorY - height > 0) {
            y = this.screen.cursorY;
        }
        this.contextMenuContainer.setPosition(x, y);
        this.contextMenuContainer.setSize(width, height);
        int innerPosX = x + 2;
        int innerPosY = y + 2;
        for (int i = 0; i < elementCount; ++i) {
            ((GuiElement)this.contextMenuContainer.elements.get(i)).setPosition(innerPosX, innerPosY + i * (elementHeight + 1)).setSize(elementWidth, elementHeight);
        }
    }

    public GuiContextMenu addContextMenuElement(GuiElement element) {
        this.contextMenuContainer.add(element);
        return this;
    }

    @Override
    public void mouseEvent(int button, boolean pressed, int mouseX, int mouseY) {
        try {
            super.mouseEvent(button, pressed, mouseX, mouseY);
        }
        catch (CancelEventException e) {
            this.screen.elements.remove(this);
        }
        if (pressed) {
            GuiElement clickElement = this.screen.getClickElementAt(mouseX, mouseY);
            if (clickElement == this) {
                this.screen.elements.remove(this);
            }
            if (clickElement == this.contextMenuContainer) {
                throw new CancelEventException();
            }
        }
    }
}

