/*
 * Decompiled with CFR 0.152.
 */
package b100.minimap;

import b100.minimap.config.Config;
import b100.minimap.config.Keybind;
import b100.minimap.config.MapConfig;
import b100.minimap.data.WorldData;
import b100.minimap.data.WorldDataManager;
import b100.minimap.gui.GuiConfigGeneral;
import b100.minimap.gui.GuiScreen;
import b100.minimap.gui.IGuiUtils;
import b100.minimap.gui.waypoint.GuiCreateWaypoint;
import b100.minimap.gui.waypoint.GuiWaypoints;
import b100.minimap.mc.IMinecraftHelper;
import b100.minimap.mc.impl.GuiUtilsImpl;
import b100.minimap.mc.impl.MinecraftHelperImpl;
import b100.minimap.render.MapRender;
import b100.minimap.render.block.BlockRenderManager;
import b100.minimap.render.block.TileColors;
import b100.minimap.render.style.MapStyle;
import b100.minimap.render.style.MapStyleCustom;
import b100.minimap.render.style.MapStyleGenerated;
import b100.minimap.render.style.MapStyleInternal;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class Minimap {
    public static final Minimap instance = new Minimap();
    public IMinecraftHelper minecraftHelper = new MinecraftHelperImpl();
    public Minecraft mc = Minecraft.getMinecraft();
    public MapRender mapRender;
    public World theWorld;
    public Config config;
    public BlockRenderManager blockRenderManager;
    public TileColors tileColors;
    public IGuiUtils guiUtils;
    public WorldDataManager worldDataManager;
    public WorldData worldData;

    private Minimap() {
        if (this.mc == null) {
            throw new NullPointerException("Minecraft is null!");
        }
    }

    public void init() {
        this.mapRender = new MapRender(this);
        this.minecraftHelper.addWorldListener(this.theWorld, this.mapRender);
        this.config = new Config();
        this.loadConfig();
        this.worldDataManager = new WorldDataManager(this);
        this.tileColors = this.minecraftHelper.getTileColors();
        this.tileColors.createTileColors();
        this.blockRenderManager = new BlockRenderManager(this.tileColors);
        this.guiUtils = new GuiUtilsImpl(this.mc);
        this.updateStyle();
    }

    public void loadConfig() {
        Minimap.log("Loading Configuration...");
        File configFolder = this.getConfigFolder();
        this.config.read(new File(configFolder, "config.txt"));
        this.config.mapConfig.read(new File(configFolder, "map.txt"));
        Minimap.log("Done!");
    }

    public void saveConfig() {
        Minimap.log("Saving Configuration...");
        File configFolder = this.getConfigFolder();
        configFolder.mkdirs();
        this.config.write(new File(configFolder, "config.txt"));
        this.config.mapConfig.write(new File(configFolder, "map.txt"));
        Minimap.log("Done!");
    }

    public void updateStyle() {
        this.mapRender.setStyle(this.getMapStyleFromConfig());
    }

    public MapStyle getMapStyleFromConfig() {
        boolean round = (Boolean)this.config.mapConfig.roundMap.value;
        int style = (Integer)this.config.mapConfig.mapStyle.value;
        if (style == 1) {
            return new MapStyleGenerated(round, 0xC22020);
        }
        if (style == 2) {
            return new MapStyleGenerated(round, 0x22B422);
        }
        if (style == 3) {
            return new MapStyleGenerated(round, 657930);
        }
        if (style == 4) {
            return new MapStyleInternal("/assets/minimap/rei/", round, true);
        }
        if (style == 5) {
            return new MapStyleInternal("/assets/minimap/zan/", round, false);
        }
        if (style == 6) {
            return new MapStyleCustom(round);
        }
        return new MapStyleGenerated(round, 997806);
    }

    public File getConfigFolder() {
        return new File(this.minecraftHelper.getMinecraftDir(), "minimap");
    }

    public void onTick() {
    }

    public void onReload() {
        this.tileColors.createTileColors();
        this.updateStyle();
    }

    public void onRenderGui(float partialTicks) {
        boolean renderGui;
        WorldClient newWorld = this.mc.currentWorld;
        if (newWorld != this.theWorld) {
            this.onWorldChange((World)newWorld);
        }
        if (this.theWorld == null) {
            return;
        }
        if (!this.guiUtils.isGuiOpened()) {
            this.updateInput();
        }
        boolean unlocked = false;
        if ((Integer)this.config.requireItem.value == 0) {
            unlocked = true;
        }
        if ((Integer)this.config.requireItem.value == 1) {
            unlocked = this.minecraftHelper.doesPlayerHaveCompass();
        }
        GuiScreen screen = this.guiUtils.getCurrentScreen();
        boolean renderMap = (Boolean)this.config.mapVisible.value != false && unlocked && this.minecraftHelper.isGuiVisible() && !this.minecraftHelper.isDebugScreenOpened() && (!this.guiUtils.isGuiOpened() || this.guiUtils.isMinimapGuiOpened() || this.minecraftHelper.isChatOpened());
        boolean bl = renderGui = screen != null;
        if (!renderMap && !renderGui) {
            return;
        }
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2912);
        GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        if (renderMap) {
            GL11.glPushMatrix();
            GL11.glOrtho((double)0.0, (double)this.minecraftHelper.getDisplayWidth(), (double)this.minecraftHelper.getDisplayHeight(), (double)0.0, (double)-1000.0, (double)1000.0);
            this.mapRender.renderMap(partialTicks);
            GL11.glPopMatrix();
        }
        if (renderGui) {
            float guiScale = this.minecraftHelper.getGuiScaleFactor();
            GL11.glPushMatrix();
            GL11.glOrtho((double)0.0, (double)((float)this.minecraftHelper.getDisplayWidth() / guiScale), (double)((float)this.minecraftHelper.getDisplayHeight() / guiScale), (double)0.0, (double)-1000.0, (double)1000.0);
            if (!screen.isInitialized()) {
                screen.init();
            }
            int w = this.minecraftHelper.getScaledWidth();
            int h = this.minecraftHelper.getScaledHeight();
            if (w != screen.width || h != screen.height) {
                screen.width = w;
                screen.height = h;
                screen.onResize();
            }
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            screen.draw(partialTicks);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
    }

    public void updateInput() {
        for (int i = 0; i < this.config.keyBinds.length; ++i) {
            boolean pressed;
            Keybind key = this.config.keyBinds[i];
            if ((Integer)key.value == Keyboard.KEY_NONE || (Integer)key.value == Keyboard.KEY_ESCAPE || (pressed = Keyboard.isKeyDown((int)((Integer)key.value))) == key.press) continue;
            key.press = pressed;
            this.keyEvent(key, pressed);
        }
    }

    public void keyEvent(Keybind keybind, boolean press) {
        if (Keyboard.isKeyDown((int)Keyboard.KEY_F3)) {
            return;
        }
        if (press) {
            if (keybind == this.config.keyMap) {
                this.guiUtils.displayGui(new GuiConfigGeneral(null));
            }
            if (keybind == this.config.keyHideMap) {
                this.config.mapVisible.value = (Boolean)this.config.mapVisible.value == false;
            }
            if (((Boolean)this.config.mapVisible.value).booleanValue()) {
                MapConfig mapConfig = this.config.mapConfig;
                if (keybind == this.config.keyFullscreen) {
                    mapConfig.fullscreenMap.toggle();
                }
                if (((Boolean)mapConfig.fullscreenMap.value).booleanValue()) {
                    if (keybind == this.config.keyZoomIn && (Integer)mapConfig.fullscreenZoomLevel.value < 4) {
                        mapConfig.fullscreenZoomLevel.value = (Integer)mapConfig.fullscreenZoomLevel.value + 1;
                    }
                    if (keybind == this.config.keyZoomOut && (Integer)mapConfig.fullscreenZoomLevel.value > 0) {
                        mapConfig.fullscreenZoomLevel.value = (Integer)mapConfig.fullscreenZoomLevel.value - 1;
                    }
                } else {
                    if (keybind == this.config.keyZoomIn && (Integer)mapConfig.zoomLevel.value < 4) {
                        mapConfig.zoomLevel.value = (Integer)mapConfig.zoomLevel.value + 1;
                    }
                    if (keybind == this.config.keyZoomOut && (Integer)mapConfig.zoomLevel.value > 0) {
                        mapConfig.zoomLevel.value = (Integer)mapConfig.zoomLevel.value - 1;
                    }
                }
                if (keybind == this.config.keyWaypointToggle) {
                    mapConfig.showWaypoints.toggle();
                }
            }
            if (keybind == this.config.keyWaypointCreate) {
                this.guiUtils.displayGui(new GuiCreateWaypoint(null));
            }
            if (keybind == this.config.keyWaypointList) {
                this.guiUtils.displayGui(new GuiWaypoints(null));
            }
        }
    }

    public void onWorldChange(World newWorld) {
        Minimap.log("World Changed!");
        if (this.worldData != null) {
            this.worldData.save();
            this.worldData = null;
        }
        this.theWorld = newWorld;
        this.minecraftHelper.onWorldChanged(newWorld);
        if (this.theWorld != null) {
            this.worldData = this.worldDataManager.getWorldData(this.theWorld);
            this.worldData.load();
            this.mapRender.onWorldChange(newWorld);
        }
        this.saveConfig();
    }

    public static void log(String str) {
        System.out.print("[MINIMAP] " + str + "\n");
    }

    static {
        instance.init();
    }
}

