/*
 * Decompiled with CFR 0.152.
 */
package toufoumaster.btwaila.tooltips.block;

import java.util.Random;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityFlowerJar;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import toufoumaster.btwaila.BTWaila;
import toufoumaster.btwaila.demo.DemoEntry;
import toufoumaster.btwaila.demo.DemoManager;
import toufoumaster.btwaila.gui.components.AdvancedInfoComponent;
import toufoumaster.btwaila.tooltips.TileTooltip;

public class JarToolTip
extends TileTooltip<TileEntityFlowerJar> {
    @Override
    public void initTooltip() {
        this.addClass(TileEntityFlowerJar.class);
    }

    @Override
    public void drawAdvancedTooltip(TileEntityFlowerJar flowerJar, AdvancedInfoComponent advancedInfoComponent) {
        Item itemFlower = Item.itemsList[flowerJar.flowerInPot];
        ItemStack flower = null;
        String flowerName = BTWaila.translator.translateKey("btwaila.tooltip.jar.item.none");
        if (itemFlower != null) {
            flower = itemFlower.getDefaultStack();
            flowerName = flower.getDisplayName();
        }
        String text = BTWaila.translator.translateKey("btwaila.tooltip.jar.planted").replace("{name}", flowerName);
        int y = advancedInfoComponent.getOffY() + 1;
        advancedInfoComponent.drawStringWithShadow(text, 0);
        Lighting.enableInventoryLight();
        if (flower != null) {
            int x = advancedInfoComponent.getPosX() + advancedInfoComponent.getGame().font.getStringWidth(text) + 2;
            Tessellator t = Tessellator.instance;
            ItemModel model = ItemModelDispatcher.getInstance().getDispatch(flower);
            model.renderItemIntoGui(t, advancedInfoComponent.getGame().font, advancedInfoComponent.getGame().textureManager, flower, x, y -= 4, 1.0f);
            model.renderItemOverlayIntoGUI(t, advancedInfoComponent.getGame().font, advancedInfoComponent.getGame().textureManager, flower, x, y, 1.0f);
        }
        Lighting.disable();
    }

    @Override
    public DemoEntry tooltipDemo(Random random) {
        TileEntityFlowerJar flowerJar = new TileEntityFlowerJar();
        flowerJar.flowerInPot = DemoManager.randomStack((Random)random).getItem().id;
        return new DemoEntry(Blocks.JAR_GLASS, 0, (TileEntity)flowerJar, new ItemStack[]{Items.JAR.getDefaultStack()});
    }
}

